define('confluence/fh/utils/dom', [
    'jquery',
    'ajs',
    'exports'
], function ($, AJS, exports) {
    'use strict';

    var $mainHeaderPlaceholder, $main, $header, $mainHeader;

    function initialize(force) {
        if (initialize.done && !force) {
            return;
        }

        var outerContentSelector = '#main .aui-page-panel-outer-content';
        // CONFDEV-35938: For backward compatibility for AUI sidebar conversion.
        $main = $(outerContentSelector).length !== 0 ? $(outerContentSelector) : $('#main');
        $header = $('#header');
        $mainHeader = $('#main-header');

        initialize.done = true;
    }

    function addClassToPage() {
        var contentType = AJS.Meta.get('content-type');
        if (contentType === 'page' || contentType === 'blogpost') {
            $(tinymce.activeEditor.getWin().document).find('body#tinymce').addClass('page-edit');
        }
    }

    function adjustMainHeaderSize() {
        initialize();
        $mainHeader.css({
            width: $main.outerWidth() - (parseInt($main.css('padding-left')) + parseInt($main.css('padding-right')))
        });
    }

    function updateTableStickyHeaderOption() {
        initialize();
        var stickyTableHeaderOffset = parseInt($mainHeader.css('top')) + $mainHeader.outerHeight();
        if (isNaN(stickyTableHeaderOffset) || stickyTableHeaderOffset === updateTableStickyHeaderOption.lastValue) {
            return;
        }
        updateTableStickyHeaderOption.lastValue = stickyTableHeaderOffset;
        AJS.trigger('sticky-table-headers.change.options', {
            fixedOffset: stickyTableHeaderOffset,
            cacheHeaderHeight: true
        });
    }

    /**
     * Translate a element vertically using CSS3
     * @param $element jQuery element
     * @param position y position
     * @param uniqueKey if this exist we will use caching to avoid DOM modification as much as possible
     */
    function translateVertical($element, position, uniqueKey) {
        if (uniqueKey) {
            translateVertical[uniqueKey] = translateVertical[uniqueKey] || {};
            if (position === translateVertical[uniqueKey].lastValue) {
                return;
            }
            translateVertical[uniqueKey].lastValue = position;
        }
        $element.css({
            transform: 'translateY(' + position + 'px)',
            '-webkit-transform': 'translateY(' + position + 'px)', // Safari
            '-ms-transform': 'translateY(' + position + 'px)' // IE 9
        });
    }

    function copyCSS($source, $target, styles) {
        var cssObj = {};
        styles.forEach(function (style) {
            cssObj[style] = $source.css(style);
        });
        $target.css(cssObj);
    }

    var cssShortcuts = {
        mt: 'margin-top',
        mr: 'margin-right',
        ml: 'margin-left',
        mb: 'margin-bottom',
        pt: 'padding-top',
        pr: 'padding-right',
        pl: 'padding-left',
        pb: 'padding-bottom',
        ff: 'font-family',
        fsi: 'font-size',
        fst: 'font-style',
        fw: 'font-weight',
        td: 'text-decoration',
        ls: 'letter-spacing',
        ta: 'text-align',
        c: 'color'
    };
    cssShortcuts.margin = [cssShortcuts.mt, cssShortcuts.mr, cssShortcuts.ml, cssShortcuts.mb];
    cssShortcuts.padding = [cssShortcuts.pt, cssShortcuts.pr, cssShortcuts.pl, cssShortcuts.pb];
    cssShortcuts.font = [cssShortcuts.ff, cssShortcuts.fsi, cssShortcuts.fst, cssShortcuts.fw];

    function createMainHeaderPlaceHolder() {
        initialize();
        if ($mainHeaderPlaceholder) {
            return $mainHeaderPlaceholder;
        }
        $mainHeaderPlaceholder = $('<div id="main-header-placeholder"></div>');
        var $titleText = $('#title-text'),
            $titleTextLink = $titleText.find('a'),
            $copyOfTitleText = $titleText.clone().removeAttr('id'),
            $copyOfTitleTextLink = $copyOfTitleText.find('a');
        // Setup place holder for main header
        copyCSS($mainHeader, $mainHeaderPlaceholder, cssShortcuts.margin.concat(cssShortcuts.padding));
        $mainHeaderPlaceholder.css({
            height: $mainHeader.outerHeight()
        });

        copyCSS($titleText, $copyOfTitleText, cssShortcuts.font.concat(cssShortcuts.td, cssShortcuts.ls, cssShortcuts.ta, cssShortcuts.pr, cssShortcuts.pb, cssShortcuts.pl, cssShortcuts.mr, cssShortcuts.mb, cssShortcuts.ml));
        $copyOfTitleText.css({
            paddingTop: parseInt($titleText.css('padding-top')) + Math.round($titleText.offset().top - $mainHeader.offset().top)
        });

        copyCSS($titleTextLink, $copyOfTitleTextLink, cssShortcuts.font.concat(cssShortcuts.margin, cssShortcuts.padding, cssShortcuts.font, cssShortcuts.c, cssShortcuts.td, cssShortcuts.ls, cssShortcuts.ta));

        $mainHeaderPlaceholder.append($copyOfTitleText);

        return $mainHeaderPlaceholder;
    }

    function removeMainHeaderPlaceHolder() {
        $mainHeaderPlaceholder && $mainHeaderPlaceholder.remove();
    }

    function scrollIfAnchor(href) {
        href = typeof(href) === 'string' ? href : $(this).attr('href');

        if (!href) {
            return;
        }

        initialize();
        var headerHeight = $header.outerHeight();

        var $target = $(href.replace(/(!|\"|\$|%|&|'|\(|\)|\*|\+|,|\.|\/|\:|;|<|=|>|\?|@|\[|\\|\]|\^|`|\{|\||\}|~)/g, '\\$1'));

        if ($target.length) {
            window.scrollTo(0, $target.offset().top - headerHeight);
            if (history && 'pushState' in history) {
                history.pushState({}, document.title, window.location.pathname + window.location.search + href);
                return false;
            }
        }
    }

    exports.forceInitialize = function () {
        initialize(true);
    };
    exports.addClassToPage = addClassToPage;
    //exports.copyCSS = copyCSS;
    //exports.cssShortcuts = cssShortcuts;
    exports.adjustMainHeaderSize = adjustMainHeaderSize;
    exports.updateTableStickyHeaderOption = updateTableStickyHeaderOption;
    exports.translateVertical = translateVertical;
    exports.createMainHeaderPlaceHolder = createMainHeaderPlaceHolder;
    exports.removeMainHeaderPlaceHolder = removeMainHeaderPlaceHolder;
    exports.scrollIfAnchor = scrollIfAnchor;
});