/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.files.notifications.email;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.internal.ContentEntityManagerInternal;
import com.atlassian.confluence.mail.notification.Notification;
import com.atlassian.confluence.mail.notification.NotificationManager;
import com.atlassian.confluence.notifications.ConfluenceUserRole;
import com.atlassian.confluence.notifications.RecipientsProviderTemplate;
import com.atlassian.confluence.notifications.content.WatchTypeUtil;
import com.atlassian.confluence.plugins.files.notifications.api.FileContentEventType;
import com.atlassian.confluence.plugins.files.notifications.email.FileContentMentionUpdatePayload;
import com.atlassian.confluence.plugins.files.notifications.email.FileContentPayload;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.access.AccessStatus;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.plugin.notifications.api.medium.recipient.RoleRecipient;
import com.atlassian.plugin.notifications.api.medium.recipient.UserKeyRoleRecipient;
import com.atlassian.plugin.notifications.spi.UserRole;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.user.User;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.HashSet;

public class FileContentRecipientProvider
extends RecipientsProviderTemplate<FileContentPayload> {
    private static final UserRole MENTION_USER_ROLE = new ConfluenceUserRole("com.atlassian.confluence.plugins.mentions");
    private static final Function<Notification, RoleRecipient> notificationToRoleRecipientFunction = notification -> new UserKeyRoleRecipient((UserRole)new ConfluenceUserRole(notification.getWatchType().name()), notification.getReceiver().getKey());
    private final ContentEntityManagerInternal contentEntityManager;
    private final NotificationManager notificationManager;
    private final UserAccessor userAccessor;
    private final ConfluenceAccessManager confluenceAccessManager;
    private final PermissionManager permissionManager;

    public FileContentRecipientProvider(NotificationManager notificationManager, ContentEntityManagerInternal contentEntityManager, UserAccessor userAccessor, ConfluenceAccessManager confluenceAccessManager, PermissionManager permissionManager) {
        this.contentEntityManager = contentEntityManager;
        this.notificationManager = notificationManager;
        this.userAccessor = userAccessor;
        this.confluenceAccessManager = confluenceAccessManager;
        this.permissionManager = permissionManager;
    }

    protected Iterable<RoleRecipient> computeUserBasedRecipients(com.atlassian.confluence.notifications.Notification<FileContentPayload> fileContentPayloadNotification) {
        FileContentPayload payload = (FileContentPayload)fileContentPayloadNotification.getPayload();
        ContentEntityObject container = this.contentEntityManager.getById(payload.getContainerNotificationContent().getContentId().asLong());
        if (container == null) {
            return Collections.emptyList();
        }
        if (payload.getType() == FileContentEventType.MENTION_IN_COMMENT) {
            FileContentMentionUpdatePayload mentionUpdatePayload = (FileContentMentionUpdatePayload)payload;
            return this.permissionFiltered((Iterable<RoleRecipient>)ImmutableList.of((Object)new UserKeyRoleRecipient(MENTION_USER_ROLE, new UserKey(mentionUpdatePayload.getMentionedUserKey()))), container);
        }
        HashSet notificationSet = new HashSet();
        payload.getFileNotificationContents().forEach(fileNotification -> {
            ContentEntityObject content = this.contentEntityManager.getById(fileNotification.getContentId().asLong());
            notificationSet.addAll(this.notificationManager.getNotificationsByContent(content));
        });
        notificationSet.addAll(this.notificationManager.getNotificationsByContent(container));
        if (container instanceof Spaced) {
            Spaced target = (Spaced)container;
            notificationSet.addAll(this.notificationManager.getNotificationsBySpace(target.getSpace()));
        }
        return this.permissionFiltered(Iterables.transform(notificationSet, notificationToRoleRecipientFunction), container);
    }

    @VisibleForTesting
    protected Iterable<RoleRecipient> permissionFiltered(Iterable<RoleRecipient> unfilteredRoleRecipients, ContentEntityObject content) {
        return Iterables.filter(unfilteredRoleRecipients, recipient -> {
            ConfluenceUser confluenceUser = this.userAccessor.getExistingUserByKey(recipient.getUserKey());
            AccessStatus userAccessStatus = this.confluenceAccessManager.getUserAccessStatus((User)confluenceUser);
            return userAccessStatus.hasLicensedAccess() && this.permissionManager.hasPermissionNoExemptions((User)confluenceUser, Permission.VIEW, (Object)content);
        });
    }

    public Iterable<UserRole> getUserRoles() {
        return WatchTypeUtil.watchTypesToUserRoles();
    }
}

