/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailtopage;

import com.atlassian.confluence.mail.notification.listeners.NotificationData;
import com.atlassian.confluence.plugins.emailgateway.api.ConfirmationNotificationSender;
import com.atlassian.confluence.plugins.emailgateway.api.StagedEmailThread;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.notifications.EmailContextBuilder;
import com.atlassian.confluence.user.notifications.EmailService;
import com.atlassian.confluence.user.notifications.NotificationSendResult;
import com.atlassian.user.User;
import java.io.Serializable;

public class DefaultEmailToPageConfirmationEmailSender
implements ConfirmationNotificationSender {
    private EmailService emailService;
    private EmailContextBuilder emailContextBuilder;

    public DefaultEmailToPageConfirmationEmailSender(EmailService emailService, SettingsManager settingsManager) {
        this.emailService = emailService;
        this.emailContextBuilder = new EmailContextBuilder(settingsManager);
    }

    public NotificationSendResult sendConfirmationEmail(User user, StagedEmailThread emailThread) {
        NotificationData notificationData = new NotificationData(user, true, null);
        String subjectMarkup = "$i18n.getText('email.to.page.name.confirmation.title', [$siteTitle])";
        notificationData.setSubject(subjectMarkup);
        notificationData.setTemplateName("confirmation.vm");
        String confirmUrl = "/email-to-page/confirm.action?hash=" + emailThread.getKey().getToken();
        String rejectUrl = "/email-to-page/reject.action?hash=" + emailThread.getKey().getToken();
        notificationData.addToContext("confirmUrl", (Serializable)((Object)confirmUrl));
        notificationData.addToContext("rejectUrl", (Serializable)((Object)rejectUrl));
        notificationData.addToContext("pageTitle", (Serializable)((Object)emailThread.getSubject()));
        notificationData.addToContext("manageNotificationsOverride", (Serializable)Boolean.valueOf(true));
        notificationData.addAllToContext(this.emailContextBuilder.getSystemContext());
        NotificationSendResult result = this.emailService.sendToEmail(notificationData, user.getEmail());
        return result;
    }
}

