/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.email.medium;

import com.atlassian.confluence.cluster.ClusterManager;
import com.atlassian.confluence.cluster.ClusterNodeInformation;
import com.atlassian.confluence.mail.MailContentProcessor;
import com.atlassian.confluence.mail.embed.MimeBodyPartReference;
import com.atlassian.confluence.mail.template.MultipartBuilder;
import com.atlassian.confluence.notifications.content.MessageIdUtil;
import com.atlassian.confluence.plugins.email.medium.MimeMultipartMessage;
import com.atlassian.confluence.plugins.email.medium.ReplyToFieldProvider;
import com.atlassian.confluence.plugins.email.medium.SystemMailFromFieldRenderer;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.fugue.Pair;
import com.atlassian.mail.Email;
import com.atlassian.mail.MailException;
import com.atlassian.mail.MailUtils;
import com.atlassian.mail.server.MailServerManager;
import com.atlassian.mail.server.SMTPMailServer;
import com.atlassian.plugin.notifications.api.ErrorCollection;
import com.atlassian.plugin.notifications.api.medium.Group;
import com.atlassian.plugin.notifications.api.medium.Message;
import com.atlassian.plugin.notifications.api.medium.NotificationAddress;
import com.atlassian.plugin.notifications.api.medium.NotificationException;
import com.atlassian.plugin.notifications.api.medium.Server;
import com.atlassian.plugin.notifications.api.medium.ServerConfiguration;
import com.atlassian.plugin.notifications.api.medium.ServerConnectionException;
import com.atlassian.plugin.util.ContextClassLoaderSwitchingUtil;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.user.User;
import com.atlassian.util.concurrent.NotNull;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.MimeBodyPart;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class ConfluenceSystemMailServer
implements Server {
    public static final String MIME_TYPE_TEXT = "text/plain";
    public static final String MIME_TYPE_HTML = "text/html";
    public static final String X_ATLASSIAN_NOTIFICATIONS_VERSION = "X-ATLASSIAN-NOTIFICATIONS-VERSION";
    public static final String X_ATLASSIAN_CLUSTER_NODE_ID = "X-ATLASSIAN-CLUSTER-NODE-ID";
    public static final String X_ATLASSIAN_CLUSTER_NODE_NAME = "X-ATLASSIAN-CLUSTER-NODE-NAME";
    private static final Logger log = Logger.getLogger(ConfluenceSystemMailServer.class);
    private final AtomicInteger messageCounter = new AtomicInteger();
    private final String version;
    private final ServerConfiguration config;
    private final MailServerManager mailServerManager;
    private final UserAccessor userAccessor;
    private final SystemMailFromFieldRenderer systemMailFromFieldRenderer;
    private final MailContentProcessor mailContentProcessor;
    private final EventPublisher eventPublisher;
    private final ReplyToFieldProvider replyToFieldProvider;
    private final ClusterManager clusterManager;

    public ConfluenceSystemMailServer(ServerConfiguration config, MailServerManager mailServerManager, UserAccessor userAccessor, MailContentProcessor mailContentProcessor, SystemMailFromFieldRenderer systemMailFromFieldRenderer, EventPublisher eventPublisher, String headerVersion, ReplyToFieldProvider replyToFieldProvider, ClusterManager clusterManager) {
        this.mailContentProcessor = mailContentProcessor;
        this.eventPublisher = eventPublisher;
        this.version = headerVersion;
        this.config = config;
        this.mailServerManager = mailServerManager;
        this.userAccessor = userAccessor;
        this.systemMailFromFieldRenderer = systemMailFromFieldRenderer;
        this.replyToFieldProvider = replyToFieldProvider;
        this.clusterManager = clusterManager;
    }

    @Deprecated
    public static String getLocalHostName() {
        return MailUtils.getLocalHostName();
    }

    public ServerConfiguration getConfig() {
        return this.config;
    }

    public ErrorCollection testConnection(I18nResolver i18n) {
        return new ErrorCollection();
    }

    public void sendIndividualNotification(NotificationAddress notificationAddress, Message message) throws NotificationException {
        block3: {
            try {
                this.send(notificationAddress, message);
            }
            catch (MailException e) {
                throw new NotificationException(e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                String errMsg = "Failed to send email to '" + notificationAddress.getAddressData() + "' with message id [" + message.getMessageId() + "]. " + e.getClass().getSimpleName() + ":" + e.getMessage() + ". ";
                log.warn((Object)errMsg);
                if (!log.isDebugEnabled()) break block3;
                log.debug((Object)"", (Throwable)e);
            }
        }
    }

    private void send(NotificationAddress notificationAddress, Message message) throws Exception {
        String emailString;
        final SMTPMailServer mailServer = this.mailServerManager.getDefaultSMTPMailServer();
        boolean isDirectEmailAddress = !notificationAddress.getMediumKey().isEmpty();
        ConfluenceUser user = isDirectEmailAddress ? null : this.userAccessor.getUserByName(notificationAddress.getAddressData());
        String string = emailString = isDirectEmailAddress ? notificationAddress.getAddressData() : user.getEmail();
        if (StringUtils.isBlank((CharSequence)emailString)) {
            StringBuilder errorMessage = new StringBuilder();
            if (user != null) {
                errorMessage.append("User '" + user.getName() + "[" + user.getKey() + "]' has no email address set. ");
            }
            errorMessage.append("No email sent for message with id '" + message.getMessageId() + "' and subject '" + message.getSubject() + "'");
            log.warn((Object)errorMessage.toString());
            return;
        }
        String subject = message.getSubject();
        if (StringUtils.isBlank((CharSequence)subject)) {
            subject = "NotificationUtil message";
        }
        final Email email = new Email(emailString);
        final String localHostName = MailUtils.getLocalHostName();
        String messageId = message.getMessageId();
        final Option<Pair<String, String>> messageIdPrefixAndModuleKey = this.computeMessageIdPrefixAndModuleKey(messageId);
        Option<String> replyToAddress = this.replyToFieldProvider.getReplyToField(message);
        if (replyToAddress.isDefined()) {
            email.setReplyTo((String)replyToAddress.get());
        }
        email.setSubject(subject);
        String processedBody = this.mailContentProcessor.process(message.getBody());
        email.setBody(processedBody);
        email.setMultipart(this.getMultipart(message));
        email.addHeader(X_ATLASSIAN_NOTIFICATIONS_VERSION, this.version);
        ClusterNodeInformation node = this.clusterManager.getThisNodeInformation();
        if (node != null) {
            email.addHeader(X_ATLASSIAN_CLUSTER_NODE_ID, node.getAnonymizedNodeIdentifier());
            Maybe nodeName = node.getHumanReadableNodeName();
            if (nodeName.isDefined()) {
                email.addHeader(X_ATLASSIAN_CLUSTER_NODE_NAME, (String)nodeName.get());
            }
        }
        UserProfile originatingUser = message.getOriginatingUser();
        String fromField = (String)message.getMetadata().get("OVERRIDE_SYSTEM_FROM_FIELD");
        fromField = fromField == null ? this.systemMailFromFieldRenderer.renderFromField(originatingUser, (User)user) : fromField;
        email.setFromName(fromField);
        email.setMimeType(MIME_TYPE_HTML);
        ContextClassLoaderSwitchingUtil.runInContext((ClassLoader)User.class.getClassLoader(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (messageIdPrefixAndModuleKey.isDefined()) {
                    String uniqueMessageId = (String)((Pair)messageIdPrefixAndModuleKey.get()).left() + "." + ConfluenceSystemMailServer.this.messageCounter.incrementAndGet() + "." + System.currentTimeMillis() + "@" + localHostName;
                    mailServer.send(email);
                } else {
                    mailServer.send(email);
                }
                return null;
            }
        });
    }

    private Option<Pair<String, String>> computeMessageIdPrefixAndModuleKey(String messageId) {
        return MessageIdUtil.extractFrom((String)messageId).map((Function)new Function<Pair<String, String>, Pair<String, String>>(){

            public Pair<String, String> apply(Pair<String, String> input) {
                return Pair.pair((Object)input.left(), (Object)String.format("contentId-%s-%s", input.right(), RandomStringUtils.randomNumeric((int)10)));
            }
        });
    }

    private String computeMessageIdSuffix(String replyToAddress) {
        if (replyToAddress != null) {
            return replyToAddress.substring(replyToAddress.lastIndexOf("@"));
        }
        return "@confluence.localhost";
    }

    private Multipart getMultipart(Message message) {
        if (!(message instanceof MimeMultipartMessage)) {
            return null;
        }
        MimeMultipartMessage mimeMultipartMessage = (MimeMultipartMessage)message;
        if (Iterables.isEmpty(mimeMultipartMessage.getRelatedBodyPartReferences())) {
            return null;
        }
        return MultipartBuilder.INSTANCE.makeMultipart((Collection)Lists.newArrayList((Iterable)Iterables.transform(mimeMultipartMessage.getRelatedBodyPartReferences(), (Function)new Function<MimeBodyPartReference, DataSource>(){

            public DataSource apply(@NotNull MimeBodyPartReference mimeBodyPartReference) {
                return mimeBodyPartReference.getSource();
            }
        })));
    }

    private MimeBodyPart createMimeBodyPart(String contentId, DataHandler dataHandler, String fileName) throws MessagingException {
        MimeBodyPart mimeBodyPart = new MimeBodyPart();
        mimeBodyPart.setDataHandler(dataHandler);
        mimeBodyPart.setHeader("Content-ID", "<" + contentId + ">");
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            mimeBodyPart.setFileName(fileName);
        }
        return mimeBodyPart;
    }

    public void sendGroupNotification(NotificationAddress toID, Message message) throws NotificationException {
        this.sendIndividualNotification(toID, message);
    }

    public List<Group> getAvailableGroups(String filter) throws ServerConnectionException {
        return null;
    }

    public ErrorCollection validateGroup(I18nResolver i18n, String groupId) {
        return null;
    }

    public void terminate() {
    }
}

