/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.polling;

import com.atlassian.mail.MailException;
import com.google.common.base.Throwables;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FolderUtils {
    private static final Logger log = LoggerFactory.getLogger(FolderUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T execute(FolderWorker<T> worker) throws MessagingException, MailException {
        T t;
        Store store = null;
        Folder folder = null;
        try {
            Session session = worker.getMailSession();
            store = session.getStore();
            store.connect();
            folder = worker.openFolder(store);
            t = worker.doWithFolder(folder);
        }
        catch (Exception e) {
            try {
                Throwables.propagateIfInstanceOf((Throwable)e, MailException.class);
                Throwables.propagateIfInstanceOf((Throwable)e, MessagingException.class);
                throw new MailException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    FolderUtils.closeQuietlyIfOpen(folder);
                    throw throwable;
                }
                finally {
                    FolderUtils.closeQuietly(store);
                }
            }
        }
        try {
            FolderUtils.closeQuietlyIfOpen(folder);
            return t;
        }
        finally {
            FolderUtils.closeQuietly(store);
        }
    }

    private static void closeQuietly(Store store) {
        if (store != null) {
            try {
                store.close();
            }
            catch (MessagingException e) {
                log.error("Failed to close mail session", (Throwable)e);
            }
        }
    }

    private static void closeQuietlyIfOpen(Folder folder) {
        try {
            if (folder == null) {
                log.debug("Folder is null - this shouldn't be happening!");
            } else if (!folder.isOpen()) {
                log.error("Folder is already closed. This may prevent previously-processed messages from being deleted!");
            } else {
                folder.close(true);
            }
        }
        catch (MessagingException e) {
            log.error("Failed to close mail folder", (Throwable)e);
        }
    }

    public static interface FolderWorker<T> {
        public Folder openFolder(Store var1) throws MessagingException;

        public T doWithFolder(Folder var1) throws MessagingException;

        public Session getMailSession() throws MailException, MessagingException;
    }
}

