/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.linkconverter.instances;

import com.atlassian.confluence.content.render.xhtml.migration.UrlResourceIdentifier;
import com.atlassian.confluence.plugins.emailgateway.api.LinkConverter;
import com.atlassian.confluence.xhtml.api.LinkBody;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class WidgetLinkConverter
implements LinkConverter<Object, MacroDefinition> {
    private final List<Pattern> patterns = ImmutableList.of((Object)Pattern.compile("youtube.com/watch\\?"), (Object)Pattern.compile("vimeo.com/[0-9]+"), (Object)Pattern.compile("maps.google(.[a-z]+)+/maps"));

    @Override
    public MacroDefinition convert(URL link, LinkBody<Object> linkBody) {
        String href = link.toExternalForm();
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(href).find()) continue;
            return new MacroDefinition("widget", null, (Map)ImmutableMap.of((Object)"url", (Object)href), (Map)ImmutableMap.of((Object)"url", (Object)new UrlResourceIdentifier(href)), "2");
        }
        return null;
    }

    @Override
    public boolean isFinal() {
        return true;
    }

    @Override
    public Class<MacroDefinition> getConversionClass() {
        return MacroDefinition.class;
    }
}

