/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.emailgateway.converter;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.MarshallingRegistry;
import com.atlassian.confluence.content.render.xhtml.MarshallingType;
import com.atlassian.confluence.content.render.xhtml.Unmarshaller;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.migration.UrlResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.DefaultEmbeddedImage;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.NamedResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.transformers.FragmentTransformer;
import com.atlassian.confluence.xhtml.api.EmbeddedImage;
import com.atlassian.renderer.RenderContext;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;

public class EmailEmbeddedImageResourceUnmarshaller
implements Unmarshaller<EmbeddedImage> {
    public EmailEmbeddedImageResourceUnmarshaller(MarshallingRegistry registry) {
        registry.register((Unmarshaller)this, EmbeddedImage.class, MarshallingType.EMAIL);
    }

    public boolean handles(StartElement startElementEvent, ConversionContext conversionContext) {
        return "img".equalsIgnoreCase(startElementEvent.getName().getLocalPart());
    }

    public EmbeddedImage unmarshal(XMLEventReader xmlEventReader, FragmentTransformer mainFragmentTransformer, ConversionContext conversionContext) throws XhtmlException {
        UrlResourceIdentifier ri;
        String src = this.getImageSrc(xmlEventReader);
        if (src.startsWith("cid:")) {
            String cid = src.substring(src.indexOf(58) + 1);
            RenderContext renderContext = ((DefaultConversionContext)conversionContext).getRenderContext();
            HashMap attachmentCidToName = (HashMap)renderContext.getParam((Object)"attachmentCidToName");
            String filename = (String)attachmentCidToName.get(cid);
            ri = new AttachmentResourceIdentifier(filename);
        } else {
            ri = new UrlResourceIdentifier(src);
        }
        return new DefaultEmbeddedImage((NamedResourceIdentifier)ri);
    }

    private String getImageSrc(XMLEventReader xmlEventReader) {
        StartElement imageStartElement = null;
        try {
            imageStartElement = xmlEventReader.peek().asStartElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        Attribute srcAttribute = imageStartElement.getAttributeByName(new QName("src"));
        return srcAttribute.getValue();
    }
}

