/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.web;

import com.atlassian.confluence.admin.criteria.MailServerExistsCriteria;
import com.atlassian.confluence.core.ConfluenceSystemProperties;
import com.atlassian.confluence.core.HeartbeatManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.user.User;
import java.util.LinkedHashMap;
import java.util.Map;

public class EditorSettingsContextProvider
implements ContextProvider {
    private final SettingsManager settingsManager;
    private final PermissionManager permissionManager;
    private final HeartbeatManager heartbeatManager;
    private final UserAccessor userAccessor;
    private final MailServerExistsCriteria mailServerExistsCriteria;

    public EditorSettingsContextProvider(SettingsManager settingsManager, PermissionManager permissionManager, UserAccessor userAccessor, HeartbeatManager heartbeatManager, MailServerExistsCriteria mailServerExistsCriteria) {
        this.settingsManager = settingsManager;
        this.permissionManager = permissionManager;
        this.userAccessor = userAccessor;
        this.heartbeatManager = heartbeatManager;
        this.mailServerExistsCriteria = mailServerExistsCriteria;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map<String, Object> getContextMap(Map<String, Object> context) {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        LinkedHashMap<String, Object> settings = new LinkedHashMap<String, Object>();
        settings.put("max-thumb-width", this.settingsManager.getGlobalSettings().getMaxThumbWidth());
        settings.put("max-thumb-height", this.settingsManager.getGlobalSettings().getMaxThumbHeight());
        settings.put("can-send-email", this.mailServerExistsCriteria.isMet());
        settings.put("is-dev-mode", ConfluenceSystemProperties.isDevMode());
        settings.put("draft-save-interval", this.settingsManager.getGlobalSettings().getDraftSaveInterval());
        settings.put("show-hidden-user-macros", this.permissionManager.hasPermission((User)currentUser, Permission.ADMINISTER, PermissionManager.TARGET_SYSTEM));
        settings.put("is-admin", this.permissionManager.isConfluenceAdministrator((User)currentUser));
        if (currentUser != null) {
            UserPreferences userPreferences = this.userAccessor.getUserPreferences((User)currentUser);
            this.addUserPreference("confluence.prefs.editor.disable.autocomplete", settings, userPreferences);
            this.addUserPreference("confluence.prefs.editor.disable.autoformat", settings, userPreferences);
        }
        settings.put("heartbeat-interval", this.heartbeatManager.getHeartbeatInterval());
        context.put("settings", settings.entrySet());
        return context;
    }

    private void addUserPreference(String property, Map<String, Object> settings, UserPreferences userPreferences) {
        settings.put(property, userPreferences.getBoolean(property));
    }
}

