/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.persistence.ContentEntityObjectDao;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.tinymceplugin.rest.entities.WikiToXhtmlConversionData;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import java.security.Principal;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/wikixhtmlconverter")
public class WikiXhtmlConverter {
    private static final Logger log = LoggerFactory.getLogger(WikiXhtmlConverter.class);
    private final EditorFormatService editorFormatService;
    private final ContentEntityObjectDao contentDao;
    @Context
    protected AuthenticationContext authContext;

    public WikiXhtmlConverter(EditorFormatService editorFormatService, ContentEntityObjectDao contentDao) {
        this.editorFormatService = editorFormatService;
        this.contentDao = contentDao;
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response convert(WikiToXhtmlConversionData data) {
        if (data == null || StringUtils.isBlank((CharSequence)data.getWiki()) || data.getEntityId() < 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (log.isDebugEnabled()) {
            Principal principal = this.authContext.getPrincipal();
            String userName = "Anonymous";
            if (principal != null) {
                userName = principal.getName();
            }
            log.debug("[{}][{}-{}]\n{}", (Object[])new String[]{userName, data.getSpaceKey(), String.valueOf(data.getEntityId()), data.getWiki()});
        }
        ContentEntityObject entity = this.contentDao.getById(data.getEntityId());
        PageContext pageContext = new PageContext(entity);
        pageContext.addParam((Object)"DO_LINK_PERMISSION_CHECK", (Object)true);
        if (data.shouldSuppressFirstParagraph()) {
            pageContext.pushRenderMode(RenderMode.suppress((long)256L));
        }
        DefaultConversionContext context = new DefaultConversionContext((RenderContext)pageContext);
        try {
            String xhtml = this.editorFormatService.convertWikiToEdit(data.getWiki(), (ConversionContext)context);
            return Response.ok((Object)xhtml).build();
        }
        catch (XhtmlException ex) {
            throw new RuntimeException(ex);
        }
    }
}

