/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.confluence.content.render.xhtml.RenderedContentCleaner;
import com.atlassian.confluence.tinymceplugin.rest.entities.WikiToXhtmlConversionData;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.sangupta.nutz.MarkdownProcessor;
import com.sangupta.nutz.ProcessingOptions;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/markdownxhtmlconverter")
public class MarkdownXhtmlConverter {
    private static final int PARSING_MAX_TIMEOUT = 2000;
    private static final Logger log = LoggerFactory.getLogger(MarkdownXhtmlConverter.class);
    private final RenderedContentCleaner renderedContentCleaner;
    @Context
    protected AuthenticationContext authContext;

    public MarkdownXhtmlConverter(RenderedContentCleaner renderedContentCleaner) {
        this.renderedContentCleaner = renderedContentCleaner;
    }

    @POST
    @AnonymousAllowed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response convert(WikiToXhtmlConversionData data) {
        if (data == null || StringUtils.isBlank((CharSequence)data.getWiki()) || data.getEntityId() < 0L) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            ProcessingOptions options = new ProcessingOptions().syntaxHighlightingOption(ProcessingOptions.SyntaxHighlightingOption.None);
            MarkdownProcessor markdownProcessor = new MarkdownProcessor(options);
            String xhtml = markdownProcessor.toHtml(data.getWiki());
            xhtml = this.renderedContentCleaner.cleanQuietly(xhtml);
            return Response.ok((Object)xhtml).build();
        }
        catch (IOException e) {
            return Response.serverError().build();
        }
    }
}

