/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.tinymceplugin.rest;

import com.atlassian.confluence.api.service.exceptions.PermissionException;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.ConversionContextOutputType;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.HtmlToXmlConverter;
import com.atlassian.confluence.content.render.xhtml.Streamable;
import com.atlassian.confluence.content.render.xhtml.Streamables;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.XmlEventReaderFactory;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.PlainTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.RichTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.editor.macro.InvalidMacroParameterException;
import com.atlassian.confluence.content.render.xhtml.editor.macro.MacroParameterTypeParser;
import com.atlassian.confluence.content.render.xhtml.storage.macro.StorageMacroBodyParser;
import com.atlassian.confluence.content.render.xhtml.transformers.FragmentTransformer;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.browser.MacroMetadataManager;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.macro.xhtml.MacroManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.webwork.ConfluenceVelocityManager;
import com.atlassian.confluence.tinymceplugin.rest.entities.Macro;
import com.atlassian.confluence.tinymceplugin.rest.entities.MacroRenderRequest;
import com.atlassian.confluence.tinymceplugin.rest.entities.PreviewMacroRequest;
import com.atlassian.confluence.tinymceplugin.rest.entities.UnmarshalMacroRequest;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.util.HtmlUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.confluence.velocity.htmlsafe.HtmlFragment;
import com.atlassian.confluence.web.context.HttpContext;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.renderer.RenderContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import com.atlassian.util.concurrent.Timeout;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

@Path(value="/macro")
@AnonymousAllowed
public class MacroResource {
    private static final Logger log = LoggerFactory.getLogger(MacroResource.class);
    private static final long MACRO_PLACEHOLDER_TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private static final String MACRO_PLACEHOLDER_TIMEOUT = "confluence.macro.placeholder.timeoutMillis";
    private static final long MACRO_DEFINITION_TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(5L, TimeUnit.SECONDS);
    private static final String MACRO_DEFINITION_TIMEOUT = "confluence.macro.definition.timeoutMillis";
    private static final long MACRO_PREVIEW_TIMEOUT_DEFAULT = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.HOURS);
    private static final String MACRO_PREVIEW_TIMEOUT = "confluence.macro.preview.timeoutMillis";
    private final XhtmlContent xhtmlContent;
    private final EditorFormatService editorFormatService;
    private final ContentEntityManager contentEntityManager;
    private final HtmlToXmlConverter htmlToXmlConverter;
    private final HttpContext httpContext;
    private final TransactionTemplate transactionTemplate;
    private final MacroManager macroManager;
    private final I18nResolver i18nResolver;
    private final PermissionManager permissionManager;
    private final MacroParameterTypeParser macroParameterTypeParser;
    private final XmlEventReaderFactory xmlEventReaderFactory;
    private final FragmentTransformer defaultFragmentTransformer;
    private final StorageMacroBodyParser storageMacroBodyParser;
    private final MacroMetadataManager macroMetadataManager;

    public MacroResource(XhtmlContent xhtmlContent, EditorFormatService editorFormatService, @Qualifier(value="contentEntityManager") ContentEntityManager contentEntityManager, @Qualifier(value="htmlToXmlConverter") HtmlToXmlConverter htmlToXmlConverter, @Qualifier(value="httpContext") HttpContext httpContext, @Qualifier(value="xhtmlMacroManager") MacroManager macroManager, I18nResolver i18nResolver, TransactionTemplate transactionTemplate, PermissionManager permissionManager, MacroParameterTypeParser macroParameterTypeParser, XmlEventReaderFactory xmlEventReaderFactory, FragmentTransformer defaultFragmentTransformer, StorageMacroBodyParser storageMacroBodyParser, MacroMetadataManager macroMetadataManager) {
        this.xhtmlContent = xhtmlContent;
        this.editorFormatService = editorFormatService;
        this.contentEntityManager = contentEntityManager;
        this.htmlToXmlConverter = htmlToXmlConverter;
        this.httpContext = httpContext;
        this.macroManager = macroManager;
        this.i18nResolver = i18nResolver;
        this.transactionTemplate = transactionTemplate;
        this.permissionManager = permissionManager;
        this.macroParameterTypeParser = macroParameterTypeParser;
        this.xmlEventReaderFactory = xmlEventReaderFactory;
        this.defaultFragmentTransformer = defaultFragmentTransformer;
        this.storageMacroBodyParser = storageMacroBodyParser;
        this.macroMetadataManager = macroMetadataManager;
    }

    @POST
    @Path(value="/placeholder")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response generatePlaceHolder(MacroRenderRequest renderRequest) {
        log.debug("Macro placeholder request for {} received", (Object)renderRequest.getMacro().getName());
        try {
            Long contentId = renderRequest.getContentId();
            Macro macro = renderRequest.getMacro();
            String macroName = renderRequest.getMacro().getName();
            com.atlassian.confluence.macro.Macro realMacro = this.macroManager.getMacroByName(macroName);
            if (realMacro == null) {
                throw new RuntimeException("The macro " + macroName + " is not available. Perhaps it has been disabled or removed.");
            }
            MacroBody macroBody = MacroResource.getMacroBody(macro, realMacro);
            Map<String, String> macroParameters = macro.getParams();
            MacroDefinition macroDefinition = MacroDefinition.builder((String)macro.getName()).withMacroBody(macroBody).withParameters(macroParameters).withStorageVersion("1").withSchemaVersion(this.getSchemaVersion(macro)).build();
            macroDefinition.setDefaultParameterValue(macro.getDefaultParameterValue());
            String entity = this.editorFormatService.convertMacroDefinitionToEdit(macroDefinition, this.getConversionContext(contentId, false, MACRO_PLACEHOLDER_TIMEOUT, MACRO_PLACEHOLDER_TIMEOUT_DEFAULT));
            log.debug("Macro placeholder render complete");
            return Response.ok((Object)entity).build();
        }
        catch (XhtmlException e) {
            throw new RuntimeException(e);
        }
        catch (PermissionException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @Nullable
    private static MacroBody getMacroBody(Macro macroEntity, com.atlassian.confluence.macro.Macro realMacro) {
        if (realMacro.getBodyType() == Macro.BodyType.RICH_TEXT) {
            return RichTextMacroBody.withStorage((Streamable)Streamables.from((String)macroEntity.getBody()));
        }
        if (realMacro.getBodyType() == Macro.BodyType.PLAIN_TEXT) {
            return new PlainTextMacroBody(macroEntity.getBody());
        }
        return null;
    }

    private int getSchemaVersion(Macro macro) {
        int schemaVersion = macro.getSchemaVersion();
        if (schemaVersion == 0) {
            MacroMetadata metadata = this.macroMetadataManager.getMacroMetadataByName(macro.getName());
            Preconditions.checkState((metadata != null ? 1 : 0) != 0, (Object)("No macro metadata found for macro '" + macro.getName() + "; cannot determine macro schema version"));
            return metadata.getFormDetails().getSchemaVersion();
        }
        return schemaVersion;
    }

    @POST
    @Path(value="/definition")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response generateDefinition(UnmarshalMacroRequest unmarshalMacroRequest) {
        Long contentId = unmarshalMacroRequest.getContentId();
        try {
            String macroXhtml = this.htmlToXmlConverter.convert(unmarshalMacroRequest.getMacroHtml());
            MacroDefinition macroDefinition = this.editorFormatService.convertEditToMacroDefinition(macroXhtml, this.getConversionContext(contentId, false, MACRO_DEFINITION_TIMEOUT, MACRO_DEFINITION_TIMEOUT_DEFAULT));
            Macro macro = MacroResource.buildMacroEntity(macroDefinition);
            return Response.ok((Object)macro).build();
        }
        catch (XhtmlException | XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (PermissionException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    private static Macro buildMacroEntity(MacroDefinition macroDefinition) {
        Macro macro = new Macro();
        macro.setName(macroDefinition.getName());
        macro.setSchemaVersion(macroDefinition.getSchemaVersion());
        macro.setParams(macroDefinition.getParameters());
        macro.setDefaultParameterValue(macroDefinition.getDefaultParameterValue());
        macro.setBody(macroDefinition.getBodyText());
        return macro;
    }

    @POST
    @Path(value="/preview")
    @Consumes(value={"application/json"})
    @Produces(value={"text/plain"})
    public Response generatePreview(PreviewMacroRequest previewMacroRequest) {
        StringWriter result = new StringWriter();
        try {
            String macroName = previewMacroRequest.getMacro().getName();
            com.atlassian.confluence.macro.Macro realMacro = this.macroManager.getMacroByName(macroName);
            String macroPreview = realMacro == null ? this.i18nResolver.getText("tinymce.macro.unknownMacro", new Serializable[]{HtmlUtil.htmlEncode((String)macroName)}) : (String)this.transactionTemplate.execute(() -> {
                try {
                    Macro macro = previewMacroRequest.getMacro();
                    ConversionContext context = this.getConversionContext(previewMacroRequest.getContentId(), true, MACRO_PREVIEW_TIMEOUT, MACRO_PREVIEW_TIMEOUT_DEFAULT);
                    Object macroBody = realMacro.getBodyType() == Macro.BodyType.RICH_TEXT ? this.getRichTextMacroBody(macro, context) : (realMacro.getBodyType() == Macro.BodyType.PLAIN_TEXT ? new PlainTextMacroBody(macro.getBody()) : null);
                    Map typedParameters = this.macroParameterTypeParser.parseMacroParameters(macro.getName(), macro.getParams(), context);
                    MacroDefinition definition = MacroDefinition.builder((String)macro.getName()).withMacroBody(macroBody).withParameters(macro.getParams()).withTypedParameters(typedParameters).withStorageVersion("2").withSchemaVersion(this.getSchemaVersion(macro)).build();
                    definition.setDefaultParameterValue(macro.getDefaultParameterValue());
                    if (macro.getDefaultParameterValue() != null) {
                        definition.setTypedParameter("", this.macroParameterTypeParser.parseMacroParameter(macro.getName(), "", macro.getDefaultParameterValue(), macro.getParams(), context));
                    }
                    return this.xhtmlContent.convertMacroDefinitionToView(definition, context);
                }
                catch (XhtmlException | InvalidMacroParameterException | XMLStreamException e) {
                    return this.i18nResolver.getText("tinymce.macro.preview.exception", new Serializable[]{HtmlUtil.htmlEncode((String)e.getMessage())});
                }
                catch (PermissionException e) {
                    throw new UncheckedExecutionException((Throwable)e);
                }
            });
            Context context = ConfluenceVelocityManager.getConfluenceVelocityContext();
            context.put("macroPreview", (Object)new HtmlFragment((Object)StringUtils.defaultString((String)macroPreview)));
            context.put("req", (Object)this.httpContext.getRequest());
            VelocityUtils.renderTemplateWithoutSwallowingErrors((String)"content/render/xhtml/preview-macro-template.vm", (Context)context, (Writer)result);
        }
        catch (UncheckedExecutionException e) {
            if (e.getCause() instanceof PermissionException) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return Response.ok((Object)result.toString()).build();
    }

    private MacroBody getRichTextMacroBody(Macro macro, ConversionContext context) throws XMLStreamException, XhtmlException {
        return this.storageMacroBodyParser.getMacroBody(macro.getName(), this.xmlEventReaderFactory.createStorageXmlEventReader((Reader)new StringReader(macro.getBody())), context, this.defaultFragmentTransformer);
    }

    private ConversionContext getConversionContext(Long contentId, boolean isPreview, String timeoutProperty, long timeoutDefault) throws PermissionException {
        PageContext ctx;
        ContentEntityObject contentEntityObject = this.contentEntityManager.getById(contentId.longValue());
        long timeoutMillis = Long.getLong(timeoutProperty, timeoutDefault);
        if (contentEntityObject == null) {
            ctx = PageContext.contextWithTimeout(null, (Timeout)Timeout.getMillisTimeout((long)timeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS));
        } else {
            if (!this.permissionManager.hasPermission((User)AuthenticatedUserThreadLocal.get(), Permission.VIEW, (Object)contentEntityObject)) {
                throw new PermissionException("User " + AuthenticatedUserThreadLocal.get() + " does not have permission to view " + contentEntityObject);
            }
            ctx = PageContext.contextWithTimeout((ContentEntityObject)contentEntityObject, (Timeout)Timeout.getMillisTimeout((long)timeoutMillis, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        if (isPreview) {
            ctx.setOutputType(ConversionContextOutputType.PREVIEW.value());
        }
        return new DefaultConversionContext((RenderContext)ctx);
    }
}

