/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.upgrade;

import com.atlassian.confluence.plugins.edgeindex.EdgeIndexBuilder;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EdgeIndexRebuildUpgradeTask
implements PluginUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(EdgeIndexRebuildUpgradeTask.class);
    private final EdgeIndexBuilder edgeIndexBuilder;

    public EdgeIndexRebuildUpgradeTask(EdgeIndexBuilder edgeIndexBuilder) {
        this.edgeIndexBuilder = edgeIndexBuilder;
    }

    public int getBuildNumber() {
        return 1;
    }

    public String getShortDescription() {
        return "Rebuild Edge Index";
    }

    public Collection<Message> doUpgrade() throws Exception {
        try {
            log.info("Rebuilding Edge Index");
            this.edgeIndexBuilder.rebuild(EdgeIndexBuilder.EDGE_INDEX_REBUILD_DEFAULT_START_PERIOD, EdgeIndexBuilder.RebuildCondition.ONLY_IF_INDEX_PRESENT);
            log.info("Edge Index rebuild complete");
            return Collections.emptySet();
        }
        catch (Exception ex) {
            log.error("Edge index rebuild failed", (Throwable)ex);
            return Collections.singleton(EdgeIndexRebuildUpgradeTask.toMessage(ex));
        }
    }

    private static Message toMessage(final Exception ex) {
        return new Message(){

            public String getKey() {
                return "edge.index.rebuild.upgrade.task.failed";
            }

            public Serializable[] getArguments() {
                return new Serializable[]{ex.getLocalizedMessage()};
            }
        };
    }

    public String getPluginKey() {
        return "com.atlassian.confluence.plugins.confluence-edge-index";
    }
}

