/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.rest;

import com.atlassian.confluence.plugins.edgeindex.EdgeQueries;
import com.atlassian.confluence.plugins.edgeindex.EdgeQueryParameter;
import com.atlassian.confluence.plugins.edgeindex.EdgeTypeRepository;
import com.atlassian.confluence.plugins.edgeindex.ScoreConfig;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityEdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityObjectId;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeType;
import com.atlassian.confluence.plugins.edgeindex.rest.StreamItemFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@Path(value="/stream")
public class StreamResource {
    private static final int ITEMS_PER_PAGE = 10;
    private static final long POPULAR_STREAM_DEFAULT_DAYS = 7L;
    private final TransactionTemplate transactionTemplate;
    private final EdgeQueries edgeQueries;
    private final EdgeTypeRepository edgeTypeRepository;
    private final StreamItemFactory streamItemFactory;

    public StreamResource(TransactionTemplate transactionTemplate, EdgeQueries edgeQueries, EdgeTypeRepository edgeTypeRepository, StreamItemFactory streamItemFactory) {
        this.transactionTemplate = transactionTemplate;
        this.edgeQueries = edgeQueries;
        this.edgeTypeRepository = edgeTypeRepository;
        this.streamItemFactory = streamItemFactory;
    }

    @GET
    @Path(value="/content")
    @Consumes(value={"application/json", "application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    @AnonymousAllowed
    public Response getMostPopular(@QueryParam(value="days") Long days, @QueryParam(value="pageSize") Integer pageSizeQueryParam, @QueryParam(value="excerpt") @DefaultValue(value="false") boolean excerpt, @QueryParam(value="thumbnails") @DefaultValue(value="false") boolean thumbnails, @QueryParam(value="nextPageOffset") String nextPageOffset, @QueryParam(value="debug") @DefaultValue(value="false") boolean debug, @QueryParam(value="followeeEdge") Float followeeEdge, @QueryParam(value="commentCreateEdge") Float commentCreateEdge, @QueryParam(value="likeCreateEdge") Float likeCreateEdge, @QueryParam(value="timeDecayBase") Float timeDecayBase, @QueryParam(value="urlStrategy") @DefaultValue(value="desktop") String urlStrategy, @QueryParam(value="edgeTypes") String edgeTypes) {
        ScoreConfig scoreConfig = new ScoreConfig();
        if (followeeEdge != null) {
            scoreConfig.setFolloweeEdge(followeeEdge.floatValue());
        }
        if (commentCreateEdge != null) {
            scoreConfig.setScore((EdgeType)this.edgeTypeRepository.getEdgeIndexTypeByKey("comment.create").get(), commentCreateEdge.floatValue());
        }
        if (likeCreateEdge != null) {
            scoreConfig.setScore((EdgeType)this.edgeTypeRepository.getEdgeIndexTypeByKey("like.create").get(), likeCreateEdge.floatValue());
        }
        if (timeDecayBase != null) {
            scoreConfig.setTimeDecayBase(timeDecayBase.floatValue());
        }
        EdgeQueryParameter queryParameter = EdgeQueryParameter.builder().since(days == null ? 7L : days, TimeUnit.DAYS).withEdgeTypes(!Strings.isNullOrEmpty((String)edgeTypes) ? Lists.newArrayList((Iterable)Splitter.on((char)',').split((CharSequence)edgeTypes)) : null).withScoreConfig(scoreConfig).build();
        List<EdgeTargetInfo> edgeTargetInfoList = this.edgeQueries.getMostPopular(queryParameter);
        int pageSize = pageSizeQueryParam == null ? 10 : pageSizeQueryParam;
        long contentIdOffset = -1L;
        if (StringUtils.isNotBlank((CharSequence)nextPageOffset)) {
            try {
                contentIdOffset = Long.parseLong(nextPageOffset);
            }
            catch (NumberFormatException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Invalid nextPageOffset: " + nextPageOffset)).build();
            }
        }
        LinkedList<EdgeTargetInfo> edgeTargetInfosSubset = new LinkedList<EdgeTargetInfo>();
        long lastPageOffset = -1L;
        boolean foundOffset = contentIdOffset == -1L;
        int counter = 0;
        Iterator<EdgeTargetInfo> edgeTargetIdIterator = edgeTargetInfoList.iterator();
        while (edgeTargetIdIterator.hasNext() && counter < pageSize + 1) {
            EdgeTargetInfo edgeTargetInfo = edgeTargetIdIterator.next();
            if (!(edgeTargetInfo instanceof ContentEntityEdgeTargetInfo) || "mobile".equalsIgnoreCase(urlStrategy) && "attachment".equalsIgnoreCase(edgeTargetInfo.getTargetType())) continue;
            ContentEntityEdgeTargetInfo contentEntityObjectInfo = (ContentEntityEdgeTargetInfo)edgeTargetInfo;
            ContentEntityObjectId contentEntityObjectId = contentEntityObjectInfo.getTargetId();
            if (!foundOffset) {
                boolean bl = foundOffset = contentEntityObjectId.getId() == contentIdOffset;
            }
            if (!foundOffset) continue;
            edgeTargetInfosSubset.add(edgeTargetInfo);
            lastPageOffset = contentEntityObjectId.getId();
            ++counter;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (edgeTargetInfosSubset.size() > pageSize) {
            edgeTargetInfosSubset.removeLast();
            result.put("nextPageOffset", lastPageOffset);
        }
        List streamItems = (List)this.transactionTemplate.execute(() -> this.streamItemFactory.fromEdgeTargetInfos(edgeTargetInfosSubset, urlStrategy, debug));
        result.put("streamItems", streamItems);
        return Response.ok(result).build();
    }
}

