/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.plugin;

import com.atlassian.confluence.plugins.edgeindex.EdgeTypeRepository;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeType;
import com.atlassian.confluence.plugins.edgeindex.plugin.EdgeTypeModuleDescriptor;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleDisabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class PluggableEdgeTypeRepository
implements InitializingBean,
DisposableBean,
EdgeTypeRepository {
    private final PluginAccessor pluginAccessor;
    private final PluginEventManager pluginEventManager;
    private volatile Map<String, EdgeType> edgeTypeByKey;
    private final AtomicBoolean refresh = new AtomicBoolean(true);

    public PluggableEdgeTypeRepository(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.pluginAccessor = pluginAccessor;
        this.pluginEventManager = pluginEventManager;
        this.loadEdgeIndexTypes();
    }

    @Override
    public Option<EdgeType> getEdgeIndexTypeByKey(String key) {
        this.refreshEdgeTypes();
        return Option.option((Object)this.edgeTypeByKey.get(key));
    }

    @Override
    public Collection<EdgeType> getEdgeIndexTypes() {
        this.refreshEdgeTypes();
        ArrayList<EdgeType> weightedEdgeTypes = new ArrayList<EdgeType>(this.edgeTypeByKey.values());
        Collections.sort(weightedEdgeTypes, (o1, o2) -> {
            int w2;
            int w1 = o1.getEdgeUiSupport().getWeight();
            return w1 > (w2 = o2.getEdgeUiSupport().getWeight()) ? 1 : (w1 < w2 ? -1 : 0);
        });
        return weightedEdgeTypes;
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (event.getModule() instanceof EdgeTypeModuleDescriptor) {
            this.refresh.set(true);
        }
    }

    @PluginEventListener
    public void onPluginModuleDisabled(PluginModuleDisabledEvent event) {
        if (event.getModule() instanceof EdgeTypeModuleDescriptor) {
            this.refresh.set(true);
        }
    }

    @PluginEventListener
    public void onPluginDisabled(PluginDisabledEvent event) {
        if (event.getPlugin().getModuleDescriptorsByModuleClass(EdgeTypeModuleDescriptor.class).size() > 0) {
            this.refresh.set(true);
        }
    }

    private void loadEdgeIndexTypes() {
        List descriptorsByClass = this.pluginAccessor.getEnabledModuleDescriptorsByClass(EdgeTypeModuleDescriptor.class);
        HashMap<String, EdgeType> edgeTypeByKey = new HashMap<String, EdgeType>(descriptorsByClass.size());
        for (EdgeTypeModuleDescriptor edgeTypeModuleDescriptor : descriptorsByClass) {
            EdgeType edgeType = edgeTypeModuleDescriptor.getModule();
            edgeTypeByKey.put(edgeType.getKey(), edgeType);
        }
        this.edgeTypeByKey = Collections.unmodifiableMap(edgeTypeByKey);
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    private void refreshEdgeTypes() {
        while (this.refresh.compareAndSet(true, false)) {
            this.loadEdgeIndexTypes();
        }
    }
}

