/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.lucene.tasks;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.plugins.edgeindex.lucene.OriginalFieldVisitor;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.EdgeIndexTask;
import com.atlassian.confluence.search.lucene.extractor.ContentPermissionsExtractor;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.collections.CollectionUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocsEnum;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ReIndexPermissionsIndexTask
implements EdgeIndexTask {
    private static final Logger log = LoggerFactory.getLogger(ReIndexPermissionsIndexTask.class);
    private final String contentId;
    private final ContentEntityManager contentEntityManager;
    private final ContentPermissionsExtractor contentPermissionsExtractor;
    private final TransactionTemplate txTemplate;

    public ReIndexPermissionsIndexTask(String contentId, ContentPermissionsExtractor contentPermissionsExtractor, ContentEntityManager contentEntityManager, TransactionTemplate txTemplate) {
        this.contentId = contentId;
        this.contentPermissionsExtractor = contentPermissionsExtractor;
        this.contentEntityManager = contentEntityManager;
        this.txTemplate = txTemplate;
    }

    public String getDescription() {
        return String.format("Reindex permissions task on content ID '%s'.", this.contentId);
    }

    public void perform(IndexWriter writer) throws IOException {
        this.txTemplate.execute(() -> {
            try {
                this.doReindex(writer);
                return null;
            }
            catch (IOException e) {
                return Throwables.propagate((Throwable)e);
            }
        });
    }

    private void doReindex(IndexWriter writer) throws IOException {
        log.debug("Beginning permissions re-indexing process for content {}", (Object)this.contentId);
        ContentEntityObject contentEntity = this.contentEntityManager.getById(Long.parseLong(this.contentId));
        if (contentEntity != null) {
            this.doReindex(writer, contentEntity);
        } else {
            log.debug("Cannot reindex content {} - no such ContentEntityObject found", (Object)this.contentId);
        }
    }

    private void doReindex(IndexWriter writer, ContentEntityObject contentEntity) throws IOException {
        List<Document> existingDocuments = this.readAndDeleteExistingDocuments(writer, contentEntity);
        log.trace("Found and deleted {} old permissions documents in the edge index for content {}", (Object)existingDocuments.size(), (Object)this.contentId);
        Map<String, Optional<IndexableField>> updatedFields = this.getUpdatedContentPermissionFields(contentEntity);
        log.trace("Found updated content permission fields {} for content {}", updatedFields.keySet(), (Object)this.contentId);
        ReIndexPermissionsIndexTask.updateAndReplaceDocuments(writer, existingDocuments, updatedFields);
        log.debug("Completed permissions re-indexing for content {}", (Object)this.contentId);
    }

    private static void updateAndReplaceDocuments(IndexWriter writer, Collection<Document> existingDocuments, Map<String, Optional<IndexableField>> updatedFields) throws IOException {
        for (Document existingDocument : existingDocuments) {
            for (Map.Entry<String, Optional<IndexableField>> newFieldEntry : updatedFields.entrySet()) {
                existingDocument.removeField(newFieldEntry.getKey());
                Optional<IndexableField> newValue = newFieldEntry.getValue();
                if (!newValue.isPresent()) continue;
                existingDocument.add((IndexableField)newValue.get());
            }
            writer.addDocument((Iterable)existingDocument);
        }
    }

    private Map<String, Optional<IndexableField>> getUpdatedContentPermissionFields(ContentEntityObject contentEntity) {
        IndexableField permissionSetsField = this.getUpdatedContentPermissionsField(contentEntity);
        return ImmutableMap.of((Object)"permissionSets", (Object)Optional.fromNullable((Object)permissionSetsField));
    }

    private List<Document> readAndDeleteExistingDocuments(IndexWriter writer, ContentEntityObject contentEntity) throws IOException {
        Term edgeContentIdTerm = new Term("edge.targetId", this.contentId);
        ArrayList<Term> edgeEntityIdTerms = new ArrayList<Term>();
        edgeEntityIdTerms.add(edgeContentIdTerm);
        List comments = contentEntity.getComments();
        for (Comment comment : comments) {
            if (CollectionUtils.isEmpty((Collection)comment.getChildren())) continue;
            String commentId = comment.getIdAsString();
            edgeEntityIdTerms.add(new Term("edge.targetId", commentId));
        }
        List<Document> documents = ReIndexPermissionsIndexTask.findMatchingDocuments(writer, edgeEntityIdTerms);
        for (Term term : edgeEntityIdTerms) {
            writer.deleteDocuments(term);
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Document> findMatchingDocuments(IndexWriter writer, List<Term> edgeEntityIdTerms) throws IOException {
        LinkedList documents = Lists.newLinkedList();
        try (DirectoryReader reader = null;){
            reader = DirectoryReader.open((IndexWriter)writer, (boolean)true);
            for (AtomicReaderContext atomicReaderContext : reader.leaves()) {
                AtomicReader atomicReader = atomicReaderContext.reader();
                for (Term edgeEntityIdTerm : edgeEntityIdTerms) {
                    DocsEnum docsEnum = atomicReader.termDocsEnum(edgeEntityIdTerm);
                    if (docsEnum == null) continue;
                    while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                        OriginalFieldVisitor visitor = new OriginalFieldVisitor();
                        atomicReader.document(docsEnum.docID(), (StoredFieldVisitor)visitor);
                        documents.add(visitor.getDocument());
                    }
                }
            }
        }
        return documents;
    }

    private IndexableField getUpdatedContentPermissionsField(ContentEntityObject contentEntity) {
        Document document = new Document();
        this.contentPermissionsExtractor.addFields(document, new StringBuffer(), (Searchable)contentEntity);
        return document.getField("permissionSets");
    }
}

