/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.lucene.tasks;

import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.EdgeIndexTask;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class DeleteEdgeTypeByUserDocumentIndexTask
implements EdgeIndexTask {
    private final String edgeTypeKey;
    private final String targetId;
    private final UserKey userKey;

    public DeleteEdgeTypeByUserDocumentIndexTask(String edgeTypeKey, String targetId, UserKey userKey) {
        this.edgeTypeKey = (String)Preconditions.checkNotNull((Object)edgeTypeKey);
        this.targetId = (String)Preconditions.checkNotNull((Object)targetId);
        this.userKey = userKey;
    }

    public String getDescription() {
        return String.format("Delete like edge on document '%s' from index.", this.targetId);
    }

    public void perform(IndexWriter writer) throws IOException {
        BooleanQuery booleanQuery = new BooleanQuery();
        booleanQuery.add((Query)new TermQuery(new Term("edge.type", this.edgeTypeKey)), BooleanClause.Occur.MUST);
        booleanQuery.add((Query)new TermQuery(new Term("edge.targetId", this.targetId)), BooleanClause.Occur.MUST);
        booleanQuery.add((Query)new TermQuery(new Term("edge.userKey", this.userKey == null ? "" : this.userKey.getStringValue())), BooleanClause.Occur.MUST);
        writer.deleteDocuments((Query)booleanQuery);
    }
}

