/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.lucene;

import com.atlassian.confluence.api.model.journal.JournalEntry;
import com.atlassian.confluence.api.model.journal.JournalIdentifier;
import com.atlassian.confluence.api.service.journal.EntryProcessorResult;
import com.atlassian.confluence.api.service.journal.JournalService;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.edgeindex.lucene.EdgeIndexTaskFactory;
import com.atlassian.confluence.plugins.edgeindex.lucene.EdgeIndexTaskQueue;
import com.atlassian.confluence.plugins.edgeindex.lucene.IndexTaskType;
import com.atlassian.confluence.plugins.edgeindex.lucene.IndexableEdge;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.EdgeIndexTask;
import com.atlassian.confluence.plugins.edgeindex.model.Edge;
import com.atlassian.confluence.search.lucene.queue.JournalIndexTaskQueue;
import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JournalEdgeIndexTaskQueue
implements EdgeIndexTaskQueue {
    private static final Logger log = LoggerFactory.getLogger(JournalIndexTaskQueue.class);
    static final JournalIdentifier JOURNAL_ID = new JournalIdentifier("edge_index");
    public static final int BATCH_SIZE = 1000;
    private final JournalService journalManager;
    private final EdgeIndexTaskFactory edgeIndexTaskFactory;
    private final TransactionTemplate transactionTemplate;
    private final ObjectMapper jsonMapper = new ObjectMapper();

    public JournalEdgeIndexTaskQueue(JournalService journalManager, EdgeIndexTaskFactory edgeIndexTaskFactory, TransactionTemplate transactionTemplate) {
        this.journalManager = (JournalService)Preconditions.checkNotNull((Object)journalManager);
        this.edgeIndexTaskFactory = (EdgeIndexTaskFactory)Preconditions.checkNotNull((Object)edgeIndexTaskFactory);
        this.transactionTemplate = (TransactionTemplate)Preconditions.checkNotNull((Object)transactionTemplate);
    }

    @Override
    public void enqueue(IndexTaskType indexTaskType, ContentEntityObject target) {
        this.enqueue(indexTaskType, this.toJson(JournalEdgeIndexTaskQueue.buildIndexableEdge(target)));
    }

    @Override
    public void enqueue(IndexTaskType indexTaskType, Edge edge) {
        this.enqueue(indexTaskType, this.toJson(JournalEdgeIndexTaskQueue.buildIndexableEdge(edge)));
    }

    private static IndexableEdge buildIndexableEdge(ContentEntityObject target) {
        return new IndexableEdge(null, null, target.getId(), null, null);
    }

    private static IndexableEdge buildIndexableEdge(Edge edge) {
        String edgeId = edge.getEdgeId() != null ? edge.getEdgeId().toString() : null;
        String userKey = edge.getUser() != null ? edge.getUser().getKey().getStringValue() : null;
        ContentEntityObject target = (ContentEntityObject)edge.getTarget();
        return new IndexableEdge(edgeId, userKey, target.getId(), edge.getDate(), edge.getEdgeType().getKey());
    }

    private String toJson(IndexableEdge indexableEdge) {
        try {
            return this.jsonMapper.writeValueAsString((Object)indexableEdge);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to serialize object", e);
        }
    }

    private void enqueue(IndexTaskType indexTaskType, String message) {
        this.journalManager.enqueue(new JournalEntry(JOURNAL_ID, indexTaskType.name(), message));
    }

    @Override
    public void processEntries(Effect<EdgeIndexTask> action) {
        this.transactionTemplate.execute(() -> {
            Integer successCount;
            while ((successCount = this.processEntriesInternal(action)) == 1000) {
            }
            return null;
        });
    }

    private Integer processEntriesInternal(Effect<EdgeIndexTask> action) {
        return (Integer)this.journalManager.processEntries(JOURNAL_ID, 1000, entries -> {
            int successCount = 0;
            for (JournalEntry entry : entries) {
                try {
                    this.toTask(entry).foreach(action);
                    ++successCount;
                }
                catch (RuntimeException e) {
                    log.warn("Failed to process edge index task for entry '" + entry + "'", (Throwable)e);
                    return EntryProcessorResult.failure((Object)successCount, (long)entry.getId());
                }
            }
            return EntryProcessorResult.success((Object)successCount);
        });
    }

    private Maybe<EdgeIndexTask> toTask(JournalEntry entry) {
        try {
            IndexableEdge edge = (IndexableEdge)this.jsonMapper.readValue(entry.getMessage(), IndexableEdge.class);
            switch (IndexTaskType.valueOf(entry.getType())) {
                case ADD_DOCUMENT: {
                    return this.edgeIndexTaskFactory.createAddDocumentTask(edge);
                }
                case DELETE_DOCUMENT: {
                    return Option.some((Object)this.edgeIndexTaskFactory.createDeleteDocumentTask(edge));
                }
                case DELETE_EDGE_BY_TARGET_ID_AND_USER: {
                    return Option.some((Object)this.edgeIndexTaskFactory.createDeleteEdgeByTargetIdAndUserTask(edge));
                }
                case DELETE_EDGE_TARGETING_DOCUMENT: {
                    return Option.some((Object)this.edgeIndexTaskFactory.createDeleteEdgeTargetingDocumentTask(edge));
                }
                case REINDEX_PERMISSIONS: {
                    return Option.some((Object)this.edgeIndexTaskFactory.createReIndexPermissionsTask(edge));
                }
            }
            throw new IllegalArgumentException("Cannot handle entries with type '" + entry.getType() + "'");
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse edge from message '" + entry.getMessage() + "'");
        }
    }
}

