/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.lucene;

import com.atlassian.bonnie.DefaultConfiguration;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.bonnie.LuceneConnection;
import com.atlassian.confluence.plugins.edgeindex.lucene.LuceneConnectionFactory;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;

public class EdgeLuceneConnectionFactory
implements LuceneConnectionFactory {
    private final LuceneConnection luceneConnection;

    public EdgeLuceneConnectionFactory(Directory directory) {
        this.luceneConnection = new LuceneConnection(directory, (Analyzer)new KeywordAnalyzer(), (ILuceneConnection.Configuration)new DefaultConfiguration(), searcher -> {
            try {
                for (AtomicReaderContext atomicReaderContext : searcher.getIndexReader().leaves()) {
                    AtomicReader atomicReader = atomicReaderContext.reader();
                    FieldCache.DEFAULT.getLongs(atomicReader, "edge.targetId", false);
                    FieldCache.DEFAULT.getLongs(atomicReader, "edge.date", false);
                    FieldCache.DEFAULT.getTermsIndex(atomicReader, "edge.type");
                    FieldCache.DEFAULT.getTermsIndex(atomicReader, "edge.targetType");
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Error warming up edge lucene connection", e);
            }
            searcher.setSimilarity((Similarity)new DefaultSimilarity(){

                public float coord(int overlap, int maxOverlap) {
                    if ((float)overlap == 0.0f) {
                        return 0.0f;
                    }
                    return 1.0f;
                }

                public float tf(float freq) {
                    if (freq == 0.0f) {
                        return 0.0f;
                    }
                    return 1.0f;
                }

                public float idf(long docFreq, long numDocs) {
                    return 1.0f;
                }

                public float queryNorm(float sumOfSquaredWeights) {
                    return 1.0f;
                }
            });
        });
    }

    @Override
    public ILuceneConnection getLuceneConnection() {
        return this.luceneConnection;
    }

    public void beanDestroyed() {
        this.luceneConnection.close();
    }
}

