/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.lucene;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InheritedContentPermissionManager;
import com.atlassian.confluence.plugins.edgeindex.EdgeDocumentFactory;
import com.atlassian.confluence.plugins.edgeindex.lucene.IndexableEdge;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.AddEdgeDocumentIndexTask;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.DeleteEdgeDocumentIndexTask;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.DeleteEdgeTargetingDocumentIndexTask;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.DeleteEdgeTypeByUserDocumentIndexTask;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.EdgeIndexTask;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.ReIndexPermissionsIndexTask;
import com.atlassian.confluence.plugins.edgeindex.model.Edge;
import com.atlassian.confluence.search.lucene.extractor.ContentPermissionsExtractor;
import com.atlassian.fugue.Maybe;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.google.common.base.Preconditions;
import java.util.Date;
import org.apache.lucene.document.Document;

public class EdgeIndexTaskFactory {
    private final EdgeDocumentFactory edgeDocumentFactory;
    private final ContentPermissionsExtractor contentPermissionsExtractor;
    private final ContentEntityManager contentEntityManager;
    private final TransactionTemplate txTemplate;

    public EdgeIndexTaskFactory(EdgeDocumentFactory edgeDocumentFactory, InheritedContentPermissionManager inheritedContentPermissionManager, ContentEntityManager contentEntityManager, TransactionTemplate txTemplate) {
        this.edgeDocumentFactory = edgeDocumentFactory;
        this.txTemplate = txTemplate;
        this.contentEntityManager = contentEntityManager;
        this.contentPermissionsExtractor = new ContentPermissionsExtractor();
        this.contentPermissionsExtractor.setInheritedContentPermissionManager(inheritedContentPermissionManager);
    }

    public EdgeIndexTask createAddDocumentTask(Edge edge) {
        Preconditions.checkArgument((boolean)(edge.getTarget() instanceof ContentEntityObject), (Object)("this target object is not supported: " + edge.getTarget()));
        UserKey userKey = edge.getUser() != null ? edge.getUser().getKey() : null;
        ContentEntityObject target = (ContentEntityObject)edge.getTarget();
        String edgeId = edge.getEdgeId() != null ? edge.getEdgeId().toString() : null;
        return this.createAddDocumentTask(edgeId, userKey, target, edge.getDate(), edge.getEdgeType().getKey());
    }

    public Maybe<EdgeIndexTask> createAddDocumentTask(IndexableEdge edge) {
        ContentEntityObject target = this.contentEntityManager.getById(edge.getTargetId().longValue());
        if (target == null) {
            return Option.none();
        }
        UserKey userKey = edge.getUserKey() != null ? new UserKey(edge.getUserKey()) : null;
        return Option.some((Object)this.createAddDocumentTask(edge.getEdgeId(), userKey, target, edge.getDate(), edge.getTypeKey()));
    }

    public EdgeIndexTask createAddDocumentTask(String edgeId, UserKey userKey, ContentEntityObject target, Date date, String edgeTypeKey) {
        Document document = this.edgeDocumentFactory.getDocument(edgeId, userKey, target, date, edgeTypeKey);
        this.addContentPermissionsField(document, target);
        return new AddEdgeDocumentIndexTask(document);
    }

    public EdgeIndexTask createDeleteDocumentTask(Edge edge) {
        return this.createDeleteDocumentTask(String.valueOf(edge.getEdgeId()));
    }

    public EdgeIndexTask createDeleteDocumentTask(IndexableEdge edge) {
        return this.createDeleteDocumentTask(edge.getEdgeId());
    }

    public EdgeIndexTask createDeleteDocumentTask(String edgeId) {
        return new DeleteEdgeDocumentIndexTask(edgeId);
    }

    public EdgeIndexTask createDeleteEdgeTargetingDocumentTask(Edge edge) {
        ContentEntityObject target = (ContentEntityObject)edge.getTarget();
        return this.createDeleteEdgeTargetingDocumentTask(target.getIdAsString());
    }

    public EdgeIndexTask createDeleteEdgeTargetingDocumentTask(IndexableEdge edge) {
        return this.createDeleteEdgeTargetingDocumentTask(edge.getTargetId().toString());
    }

    public EdgeIndexTask createDeleteEdgeTargetingDocumentTask(String targetId) {
        return new DeleteEdgeTargetingDocumentIndexTask(targetId);
    }

    public EdgeIndexTask createReIndexPermissionsTask(ContentEntityObject ceo) {
        return new ReIndexPermissionsIndexTask(ceo.getIdAsString(), this.contentPermissionsExtractor, this.contentEntityManager, this.txTemplate);
    }

    public EdgeIndexTask createReIndexPermissionsTask(IndexableEdge edge) {
        return new ReIndexPermissionsIndexTask(edge.getTargetId().toString(), this.contentPermissionsExtractor, this.contentEntityManager, this.txTemplate);
    }

    public EdgeIndexTask createDeleteEdgeByTargetIdAndUserTask(Edge edge) {
        ContentEntityObject target = (ContentEntityObject)edge.getTarget();
        UserKey userKey = edge.getUser() != null ? edge.getUser().getKey() : null;
        return new DeleteEdgeTypeByUserDocumentIndexTask(edge.getEdgeType().getKey(), target.getIdAsString(), userKey);
    }

    public EdgeIndexTask createDeleteEdgeByTargetIdAndUserTask(IndexableEdge edge) {
        return new DeleteEdgeTypeByUserDocumentIndexTask(edge.getTypeKey(), edge.getTargetId().toString(), new UserKey(edge.getUserKey()));
    }

    private void addContentPermissionsField(Document document, Object target) {
        if (target instanceof Searchable) {
            this.contentPermissionsExtractor.addFields(document, new StringBuffer(), (Searchable)target);
        }
    }
}

