/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.lucene;

import com.atlassian.bonnie.DirectoryUtil;
import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.api.model.index.IndexRecoverer;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexBuilder;
import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Qualifier;

public class EdgeIndexRecoverer
implements IndexRecoverer {
    private final ILuceneConnection luceneConnection;
    private final EdgeIndexBuilder edgeIndexBuilder;

    public EdgeIndexRecoverer(@Qualifier(value="edgeLuceneConnection") ILuceneConnection luceneConnection, @Qualifier(value="edgeIndexBuilder") EdgeIndexBuilder edgeIndexBuilder) {
        this.luceneConnection = luceneConnection;
        this.edgeIndexBuilder = edgeIndexBuilder;
    }

    public void snapshot(@Nonnull File destDir) throws IOException {
        this.luceneConnection.snapshot(DirectoryUtil.getDirectory((File)destDir));
    }

    public void reset(@Nonnull Runnable replaceIndex) {
        this.luceneConnection.reset(replaceIndex);
    }

    public void reindex() {
        this.edgeIndexBuilder.rebuild(EdgeIndexBuilder.EDGE_INDEX_REBUILD_DEFAULT_START_PERIOD, EdgeIndexBuilder.RebuildCondition.FORCE);
    }
}

