/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex.job;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.plugins.edgeindex.lucene.EdgeIndexTaskQueue;
import com.atlassian.confluence.plugins.edgeindex.lucene.tasks.EdgeIndexTask;
import com.atlassian.fugue.Effect;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.io.IOException;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class EdgeIndexQueueFlusher
implements JobRunner {
    private static final Logger log = LoggerFactory.getLogger(EdgeIndexQueueFlusher.class);
    private final EdgeIndexTaskQueue queue;
    private final ILuceneConnection luceneConnection;

    public EdgeIndexQueueFlusher(EdgeIndexTaskQueue queue, @Qualifier(value="edgeLuceneConnection") ILuceneConnection luceneConnection) {
        this.queue = queue;
        this.luceneConnection = luceneConnection;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        this.luceneConnection.withBatchUpdate(() -> this.luceneConnection.withWriter(writer -> this.queue.processEntries((Effect<EdgeIndexTask>)((Effect)indexTask -> {
            try {
                indexTask.perform(writer);
            }
            catch (RuntimeException e) {
                log.error("Error performing index task: " + indexTask, (Throwable)e);
            }
            catch (IOException e) {
                throw new RuntimeException("Non-recoverable error performing index task: " + indexTask, e);
            }
        }))));
        return null;
    }
}

