/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.content.CustomContentEntityObject;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.edgeindex.EdgeDateFieldHelper;
import com.atlassian.confluence.plugins.edgeindex.EdgeDocumentFactory;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.user.UserKey;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public class LuceneEdgeDocumentFactory
implements EdgeDocumentFactory {
    public static final String EDGE_TARGET_ID = "edge.targetId";
    public static final String EDGE_USERKEY = "edge.userKey";
    public static final String EDGE_TYPE = "edge.type";
    public static final String EDGE_ID = "edge.id";
    public static final String EDGE_TARGET_TYPE = "edge.targetType";
    private final EdgeDateFieldHelper edgeDateFieldHelper;

    public LuceneEdgeDocumentFactory(EdgeDateFieldHelper edgeDateFieldHelper) {
        this.edgeDateFieldHelper = edgeDateFieldHelper;
    }

    @Override
    public Document getDocument(String edgeId, UserKey userKey, ContentEntityObject target, Date date, String edgeTypeKey) {
        ConfluenceUser targetAuthor;
        Document document = new Document();
        document.add((IndexableField)new Field(EDGE_USERKEY, userKey == null ? "" : (String)StringUtils.defaultIfBlank((CharSequence)userKey.getStringValue(), (CharSequence)""), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((IndexableField)new Field(EDGE_TARGET_ID, String.valueOf(this.getTargetId(target)), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        long dateInSeconds = date.getTime() / 1000L;
        this.edgeDateFieldHelper.addDateField(document, dateInSeconds);
        document.add((IndexableField)new Field(EDGE_TYPE, edgeTypeKey, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        if (edgeId != null) {
            document.add((IndexableField)new Field(EDGE_ID, edgeId, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        }
        document.add((IndexableField)new Field("edge.targetAuthor", (targetAuthor = this.getTargetAuthor(target)) == null ? "" : targetAuthor.getKey().getStringValue(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        document.add((IndexableField)new Field(EDGE_TARGET_TYPE, this.getTargetType(target), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        String spaceKey = this.getSpaceKey(target);
        if (StringUtils.isNotBlank((CharSequence)spaceKey)) {
            document.add((IndexableField)new Field("spacekey", this.getSpaceKey(target), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
        } else {
            document.add((IndexableField)new Field("inSpace", "false", Field.Store.NO, Field.Index.NOT_ANALYZED));
        }
        return document;
    }

    private String getSpaceKey(Object target) {
        if (!(target instanceof Spaced)) {
            return null;
        }
        Space space = ((Spaced)target).getSpace();
        return space != null ? space.getKey() : null;
    }

    private long getTargetId(Object target) {
        if (target instanceof ContentEntityObject) {
            return ((ContentEntityObject)target).getId();
        }
        throw new UnsupportedOperationException("this target object is not supported: " + target);
    }

    private ConfluenceUser getTargetAuthor(Object target) {
        if (target instanceof ContentEntityObject) {
            return ((ContentEntityObject)target).getCreator();
        }
        return null;
    }

    private String getTargetType(Object target) {
        if (target instanceof CustomContentEntityObject) {
            return ((CustomContentEntityObject)target).getPluginModuleKey();
        }
        if (target instanceof ContentEntityObject) {
            return ((ContentEntityObject)target).getType();
        }
        throw new UnsupportedOperationException("this target object is not supported: " + target);
    }
}

