/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.plugins.edgeindex.EdgeTypeRepository;
import com.atlassian.confluence.plugins.edgeindex.ScoreConfig;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityEdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityObjectId;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeType;
import com.atlassian.fugue.Option;
import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.AtomicReader;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FieldCache;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;

public class GroupByEdgeTargetCollector
extends Collector {
    static final int DECAY_THRESHOLD_SECONDS = 86400;
    private Scorer scorer;
    private AtomicReader atomicReader;
    private final long currentTimeSeconds;
    private final EdgeTypeRepository edgeTypeRepository;
    private final ScoreConfig scoreConfig;
    Map<Long, ContentEntityEdgeTargetInfo> idToScore = new HashMap<Long, ContentEntityEdgeTargetInfo>();

    public GroupByEdgeTargetCollector(EdgeTypeRepository edgeTypeRepository, ScoreConfig scoreConfig) {
        this(edgeTypeRepository, scoreConfig, new Date());
    }

    public GroupByEdgeTargetCollector(EdgeTypeRepository edgeTypeRepository, ScoreConfig scoreConfig, Date now) {
        this.edgeTypeRepository = edgeTypeRepository;
        this.currentTimeSeconds = now.getTime() / 1000L;
        this.scoreConfig = scoreConfig;
    }

    public void collect(int docId) throws IOException {
        float score = this.scorer.score();
        SortedDocValues typeIndex = FieldCache.DEFAULT.getTermsIndex(this.atomicReader, "edge.type");
        BytesRef type = new BytesRef();
        typeIndex.get(docId, type);
        SortedDocValues targetTypeIndex = FieldCache.DEFAULT.getTermsIndex(this.atomicReader, "edge.targetType");
        BytesRef targetType = new BytesRef();
        targetTypeIndex.get(docId, targetType);
        FieldCache.Longs targetIdFieldCache = FieldCache.DEFAULT.getLongs(this.atomicReader, "edge.targetId", false);
        FieldCache.Longs dateFieldCache = FieldCache.DEFAULT.getLongs(this.atomicReader, "edge.date", false);
        long targetId = targetIdFieldCache.get(docId);
        long edgeAgeSeconds = this.currentTimeSeconds - dateFieldCache.get(docId);
        if (edgeAgeSeconds > 86400L) {
            int edgeAgeDays = this.getRoundedDays(edgeAgeSeconds);
            score *= this.timeDecayFactor(edgeAgeDays);
        }
        float finalScore = score;
        Option<EdgeType> edgeIndexTypeByKey = this.edgeTypeRepository.getEdgeIndexTypeByKey(type.utf8ToString());
        edgeIndexTypeByKey.foreach(edgeType -> {
            ContentEntityEdgeTargetInfo targetInfo = this.idToScore.get(targetId);
            if (targetInfo == null) {
                targetInfo = new ContentEntityEdgeTargetInfo(targetType.utf8ToString(), new ContentEntityObjectId(targetId), finalScore);
                this.idToScore.put(targetId, targetInfo);
            } else {
                targetInfo.incrementScore(finalScore);
            }
            this.idToScore.put(targetId, targetInfo);
        });
    }

    public void setNextReader(AtomicReaderContext context) throws IOException {
        this.atomicReader = context.reader();
    }

    private float timeDecayFactor(long edgeAgeDays) {
        return (float)(1.0 / Math.pow(this.scoreConfig.getTimeDecayBase(), edgeAgeDays));
    }

    private int getRoundedDays(long timeSeconds) {
        return (int)Math.floor((float)timeSeconds / 86400.0f + 1.0f);
    }

    public List<EdgeTargetInfo> getTopTargetsOrderedByScore() {
        if (this.idToScore.isEmpty()) {
            return Collections.emptyList();
        }
        List reverseOrderedKeys = Ordering.natural().reverse().onResultOf(Functions.forMap(this.idToScore)).sortedCopy(this.idToScore.keySet());
        ArrayList<EdgeTargetInfo> topTargets = new ArrayList<EdgeTargetInfo>(reverseOrderedKeys.size());
        for (Long key : reverseOrderedKeys) {
            topTargets.add(this.idToScore.get(key));
        }
        return topTargets;
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }
}

