/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.plugins.edgeindex.ScoreConfig;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class EdgeQueryParameter {
    private final long time;
    private final TimeUnit timeUnit;
    private final ScoreConfig scoreConfig;
    private final List<String> edgeTypes;

    public EdgeQueryParameter(long time, TimeUnit timeUnit, ScoreConfig scoreConfig, List<String> edgeTypes) {
        this.time = time;
        this.timeUnit = timeUnit;
        this.scoreConfig = scoreConfig;
        this.edgeTypes = edgeTypes;
    }

    public long getTime() {
        return this.time;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public ScoreConfig getScoreConfig() {
        return this.scoreConfig;
    }

    public List<String> getEdgeTypes() {
        return this.edgeTypes;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long number;
        private TimeUnit timeUnit;
        private ScoreConfig scoreConfig;
        private List<String> edgeTypes;

        public Builder since(long number, TimeUnit timeUnit) {
            this.number = number;
            this.timeUnit = timeUnit;
            return this;
        }

        public Builder withScoreConfig(ScoreConfig config) {
            this.scoreConfig = config;
            return this;
        }

        public Builder withEdgeTypes(List<String> edgeTypes) {
            this.edgeTypes = edgeTypes;
            return this;
        }

        public EdgeQueryParameter build() {
            if (this.scoreConfig == null) {
                this.scoreConfig = new ScoreConfig();
            }
            return new EdgeQueryParameter(this.number, this.timeUnit, this.scoreConfig, this.edgeTypes);
        }
    }
}

