/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.event.events.content.ContentEvent;
import com.atlassian.confluence.event.events.content.attachment.AttachmentEvent;
import com.atlassian.confluence.event.events.content.attachment.GeneralAttachmentVersionRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostCreateEvent;
import com.atlassian.confluence.event.events.content.comment.CommentCreateEvent;
import com.atlassian.confluence.event.events.content.page.PageCreateEvent;
import com.atlassian.confluence.event.events.like.AsyncLikeEvent;
import com.atlassian.confluence.event.events.like.AsyncLikeRemovedEvent;
import com.atlassian.confluence.event.events.permission.ContentTreePermissionReindexEvent;
import com.atlassian.confluence.event.events.types.Removed;
import com.atlassian.confluence.event.events.types.Trashed;
import com.atlassian.confluence.plugins.edgeindex.EdgeFactory;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexManager;
import com.atlassian.confluence.plugins.edgeindex.model.Edge;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.event.api.EventListener;
import com.atlassian.user.User;
import java.util.Date;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class EdgeListener {
    private EdgeIndexManager edgeIndexManager;
    private EdgeFactory edgeFactory;
    private ContentEntityManager contentEntityManager;
    private PlatformTransactionManager transactionManager;

    @EventListener
    public void onLikeEvent(AsyncLikeEvent likeEvent) {
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.execute(status -> {
            Edge likeEdge = this.edgeFactory.getLikeEdge(FindUserHelper.getUser((User)likeEvent.getOriginatingUser()), this.contentEntityManager.getById(likeEvent.getContentId()), new Date(likeEvent.getTimestamp()));
            if (likeEvent instanceof AsyncLikeRemovedEvent) {
                this.edgeIndexManager.unIndex(likeEdge);
            } else {
                this.edgeIndexManager.index(likeEdge);
            }
            return null;
        });
    }

    @EventListener
    public void onCommentCreateEvent(CommentCreateEvent commentEvent) {
        if (commentEvent.getComment() == null) {
            return;
        }
        this.edgeIndexManager.index(this.edgeFactory.getCreateEdge(commentEvent.getContent()));
    }

    @EventListener
    public void onPageCreateEvent(PageCreateEvent pageCreateEvent) {
        if (pageCreateEvent.getContent() == null) {
            return;
        }
        this.edgeIndexManager.index(this.edgeFactory.getCreateEdge(pageCreateEvent.getContent()));
    }

    @EventListener
    public void onBlogPostCreateEvent(BlogPostCreateEvent blogPostCreateEvent) {
        if (blogPostCreateEvent.getContent() == null) {
            return;
        }
        this.edgeIndexManager.index(this.edgeFactory.getCreateEdge(blogPostCreateEvent.getContent()));
    }

    @EventListener
    public void onContentRemoveEvent(Removed removedEvent) {
        if (!(removedEvent instanceof ContentEvent)) {
            return;
        }
        this.onContentEntityRemoved((ContentEvent)removedEvent);
    }

    @EventListener
    public void onContentTrashed(Trashed trashedEvent) {
        if (!(trashedEvent instanceof ContentEvent)) {
            return;
        }
        this.onContentEntityRemoved((ContentEvent)trashedEvent);
    }

    @EventListener
    public void onContentPermissionReindex(ContentTreePermissionReindexEvent e) {
        this.edgeIndexManager.reIndexPermissions(e.getContent());
    }

    private void onContentEntityRemoved(ContentEvent event) {
        ContentEntityObject content;
        Object object = content = event instanceof AttachmentEvent ? ((AttachmentEvent)event).getAttachment() : event.getContent();
        if (content == null) {
            return;
        }
        if (event instanceof GeneralAttachmentVersionRemoveEvent) {
            this.edgeIndexManager.contentEntityVersionRemoved(content);
        } else {
            this.edgeIndexManager.contentEntityRemoved(content);
        }
    }

    public void setEdgeIndexManager(EdgeIndexManager edgeIndexManager) {
        this.edgeIndexManager = edgeIndexManager;
    }

    public void setEdgeFactory(EdgeFactory edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }
}

