/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.plugins.edgeindex.EdgeQueries;
import com.atlassian.confluence.plugins.edgeindex.EdgeQueryParameter;
import com.atlassian.confluence.plugins.edgeindex.PopularContentQueries;
import com.atlassian.confluence.plugins.edgeindex.ScoreConfig;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityEdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.ContentEntityObjectId;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeTargetInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DefaultPopularContentQueries
implements PopularContentQueries {
    private final EdgeQueries edgeQueries;
    private final ContentEntityManager contentEntityManager;

    public DefaultPopularContentQueries(EdgeQueries edgeQueries, ContentEntityManager contentEntityManager) {
        this.edgeQueries = edgeQueries;
        this.contentEntityManager = contentEntityManager;
    }

    @Override
    public List<ContentEntityObject> getMostPopular(int maxResults, EdgeQueryParameter queryParameter) {
        return this.convertToObjects(maxResults, this.edgeQueries.getMostPopular(queryParameter));
    }

    @Override
    public List<ContentEntityObject> getMostPopular(int maxResults, int lastTimePeriod, TimeUnit timeUnit) {
        EdgeQueryParameter queryParameter = EdgeQueryParameter.builder().since(lastTimePeriod, timeUnit).build();
        return this.getMostPopular(maxResults, queryParameter);
    }

    @Override
    public List<ContentEntityObject> getMostPopular(int maxResults, int lastTimePeriod, TimeUnit timeUnit, ScoreConfig scoreConfig) {
        EdgeQueryParameter queryParameter = EdgeQueryParameter.builder().since(lastTimePeriod, timeUnit).build();
        return this.getMostPopular(maxResults, queryParameter);
    }

    private List<ContentEntityObject> convertToObjects(int maxResults, List<EdgeTargetInfo> targets) {
        ArrayList<ContentEntityObject> results = new ArrayList<ContentEntityObject>();
        for (EdgeTargetInfo target : targets) {
            ContentEntityObject popularContent = null;
            if (target instanceof ContentEntityEdgeTargetInfo) {
                ContentEntityObjectId targetId = ((ContentEntityEdgeTargetInfo)target).getTargetId();
                popularContent = this.contentEntityManager.getById(targetId.getId().longValue());
            }
            if (popularContent == null) continue;
            results.add(popularContent);
            if (results.size() < maxResults) continue;
            return results;
        }
        return results;
    }
}

