/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.api.model.pagination.PageRequest;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.SimplePageRequest;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.network.NetworkService;
import com.atlassian.confluence.event.events.search.PopularQueryExecutionEvent;
import com.atlassian.confluence.plugins.edgeindex.EdgeQueries;
import com.atlassian.confluence.plugins.edgeindex.EdgeQueryParameter;
import com.atlassian.confluence.plugins.edgeindex.EdgeTypeRepository;
import com.atlassian.confluence.plugins.edgeindex.GroupByEdgeTargetCollector;
import com.atlassian.confluence.plugins.edgeindex.ScoreConfig;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeTargetInfo;
import com.atlassian.confluence.plugins.edgeindex.model.EdgeType;
import com.atlassian.confluence.search.lucene.filter.ContentPermissionsFilter;
import com.atlassian.confluence.search.lucene.filter.MultiTermFilter;
import com.atlassian.confluence.search.lucene.filter.SpacePermissionsFilterFactory;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.spring.container.ContainerManager;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.ChainedFilter;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class DefaultEdgeQueries
implements EdgeQueries {
    private final UserAccessor userAccessor;
    private final SpacePermissionsFilterFactory SpacePermissionsFilterFactory;
    private final ILuceneConnection luceneConnection;
    private final EdgeTypeRepository edgeTypeRepository;
    private final NetworkService networkService;
    private final EventPublisher eventPublisher;

    public DefaultEdgeQueries(UserAccessor userAccessor, ILuceneConnection luceneConnection, EdgeTypeRepository edgeTypeRepository, NetworkService networkService, EventPublisher eventPublisher) {
        this.userAccessor = userAccessor;
        this.luceneConnection = luceneConnection;
        this.networkService = networkService;
        this.edgeTypeRepository = edgeTypeRepository;
        this.SpacePermissionsFilterFactory = (SpacePermissionsFilterFactory)ContainerManager.getComponent((String)"spacePermissionsFilterFactory");
        this.eventPublisher = eventPublisher;
    }

    @Deprecated
    public DefaultEdgeQueries(UserAccessor userAccessor, ILuceneConnection luceneConnection, EdgeTypeRepository edgeTypeRepository, NetworkService networkService) {
        this(userAccessor, luceneConnection, edgeTypeRepository, networkService, (EventPublisher)ContainerManager.getComponent((String)"eventPublisher"));
    }

    @Override
    public List<EdgeTargetInfo> getMostPopular(long number, TimeUnit timeUnit, ScoreConfig scoreConfig) {
        return this.getMostPopular(EdgeQueryParameter.builder().since(number, timeUnit).withScoreConfig(scoreConfig).build());
    }

    @Override
    public List<EdgeTargetInfo> getMostPopular(EdgeQueryParameter edgeQueryParameter) {
        ConfluenceUser remoteUser = AuthenticatedUserThreadLocal.get();
        return this.getMostPopular(edgeQueryParameter, remoteUser);
    }

    List<EdgeTargetInfo> getMostPopular(EdgeQueryParameter edgeQueryParameter, ConfluenceUser remoteUser) {
        Collection<EdgeType> edgeTypes;
        ScoreConfig scoreConfig = edgeQueryParameter.getScoreConfig();
        GroupByEdgeTargetCollector collector = new GroupByEdgeTargetCollector(this.edgeTypeRepository, scoreConfig);
        long max = System.currentTimeMillis() / 1000L;
        long min = max - TimeUnit.SECONDS.convert(edgeQueryParameter.getTime(), edgeQueryParameter.getTimeUnit());
        NumericRangeFilter numericRangeFilter = NumericRangeFilter.newLongRange((String)"edge.date", (Long)min, (Long)max, (boolean)true, (boolean)true);
        ArrayList<Object> filters = new ArrayList<Object>();
        filters.add(numericRangeFilter);
        filters.add(new ContentPermissionsFilter((com.atlassian.user.User)remoteUser, (Iterable)this.userAccessor.getGroupNames((com.atlassian.user.User)remoteUser)));
        if (edgeQueryParameter.getEdgeTypes() != null) {
            MultiTermFilter typesFilter = new MultiTermFilter();
            for (String string : edgeQueryParameter.getEdgeTypes()) {
                typesFilter.addTerm(new Term("edge.type", string));
            }
            filters.add(typesFilter);
        }
        if (!this.userAccessor.isSuperUser((com.atlassian.user.User)remoteUser)) {
            filters.add(this.SpacePermissionsFilterFactory.create((com.atlassian.user.User)remoteUser));
        }
        BooleanQuery query = new BooleanQuery();
        if (edgeQueryParameter.getEdgeTypes() == null) {
            edgeTypes = this.edgeTypeRepository.getEdgeIndexTypes();
        } else {
            edgeTypes = new ArrayList<EdgeType>(edgeQueryParameter.getEdgeTypes().size());
            for (String string : edgeQueryParameter.getEdgeTypes()) {
                Option<EdgeType> option = this.edgeTypeRepository.getEdgeIndexTypeByKey(string);
                if (!option.isDefined()) continue;
                edgeTypes.add((EdgeType)option.get());
            }
        }
        BooleanQuery booleanQuery = new BooleanQuery(true);
        booleanQuery.setMinimumNumberShouldMatch(1);
        for (EdgeType edgeType : edgeTypes) {
            if (!edgeType.getPermissionDelegate().canView(remoteUser)) continue;
            TermQuery edgeTypeQuery = new TermQuery(new Term("edge.type", edgeType.getKey()));
            float boostFactor = scoreConfig.getScore(edgeType);
            edgeTypeQuery.setBoost(boostFactor);
            booleanQuery.add((Query)edgeTypeQuery, BooleanClause.Occur.SHOULD);
        }
        query.add((Query)booleanQuery, BooleanClause.Occur.MUST);
        if (remoteUser != null) {
            SimplePageRequest simplePageRequest = new SimplePageRequest(0, 100);
            PageResponse pageResponse = this.networkService.getFollowing(remoteUser.getKey(), (PageRequest)simplePageRequest);
            for (User followee : Iterables.filter((Iterable)pageResponse, (Predicate)User.isUserKnown)) {
                UserKey key = (UserKey)followee.getUserKey().get();
                TermQuery followeeQuery = new TermQuery(new Term("edge.userKey", key.getStringValue()));
                followeeQuery.setBoost(scoreConfig.getFolloweeEdge());
                query.add((Query)followeeQuery, BooleanClause.Occur.SHOULD);
            }
        }
        ChainedFilter chainedFilter = new ChainedFilter(filters.toArray(new Filter[filters.size()]), 1);
        long l = System.currentTimeMillis();
        this.luceneConnection.withSearch(searcher -> searcher.search((Query)query, (Filter)chainedFilter, (Collector)collector));
        long end = System.currentTimeMillis();
        this.eventPublisher.publish((Object)new PopularQueryExecutionEvent(l, end));
        return collector.getTopTargetsOrderedByScore();
    }
}

