/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.edgeindex;

import com.atlassian.bonnie.ILuceneConnection;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.like.LikeEntity;
import com.atlassian.confluence.persistence.EntityManagerProvider;
import com.atlassian.confluence.plugins.edgeindex.EdgeFactory;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexBuilder;
import com.atlassian.confluence.plugins.edgeindex.EdgeIndexManager;
import com.atlassian.confluence.plugins.edgeindex.model.Edge;
import com.atlassian.confluence.plugins.edgeindex.servlet.EdgeIndexRebuiltEvent;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import java.util.Date;
import java.util.List;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.TypedQuery;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class DefaultEdgeIndexBuilder
implements EdgeIndexBuilder {
    private static final Logger log = LoggerFactory.getLogger(DefaultEdgeIndexBuilder.class);
    private final EdgeIndexManager edgeIndexManager;
    private final TransactionTemplate transactionTemplate;
    private final EdgeFactory edgeFactory;
    private final ILuceneConnection luceneConnection;
    private final EntityManagerProvider entityManagerProvider;
    private final EventPublisher eventPublisher;

    public DefaultEdgeIndexBuilder(EdgeIndexManager edgeIndexManager, TransactionTemplate transactionTemplate, EdgeFactory edgeFactory, @Qualifier(value="edgeLuceneConnection") ILuceneConnection luceneConnection, EntityManagerProvider entityManagerProvider, EventPublisher eventPublisher) {
        this.edgeIndexManager = edgeIndexManager;
        this.transactionTemplate = transactionTemplate;
        this.edgeFactory = edgeFactory;
        this.luceneConnection = luceneConnection;
        this.entityManagerProvider = entityManagerProvider;
        this.eventPublisher = eventPublisher;
    }

    @Override
    public void rebuild(Period since, EdgeIndexBuilder.RebuildCondition rebuildCondition) {
        if (rebuildCondition == EdgeIndexBuilder.RebuildCondition.ONLY_IF_INDEX_PRESENT && this.getExistingDocumentCount() == 0) {
            log.info("No existing documents in edge index, skipping reindex");
            return;
        }
        Date startDate = new DateTime().minus((ReadablePeriod)since).toDate();
        this.deleteExistingDocuments();
        this.transactionTemplate.execute(() -> {
            List<ContentEntityObject> contentEntities = this.getContentCreatedSince(startDate);
            this.luceneConnection.withBatchUpdate(() -> {
                this.addContentToIndex(contentEntities);
                List<Object[]> likes = this.getLikesSince(startDate);
                this.addLikesToIndex(likes);
            });
            return null;
        });
        this.eventPublisher.publish((Object)new EdgeIndexRebuiltEvent(since));
    }

    private int getExistingDocumentCount() {
        return (Integer)this.luceneConnection.withReader(IndexReader::numDocs);
    }

    private void deleteExistingDocuments() {
        this.luceneConnection.withWriter(IndexWriter::deleteAll);
    }

    private void addLikesToIndex(List<Object[]> likes) {
        for (Object[] like : likes) {
            ContentEntityObject contentEntity = (ContentEntityObject)like[0];
            LikeEntity likeEntity = (LikeEntity)like[1];
            Edge likeEdge = this.edgeFactory.getLikeEdge(likeEntity.getUser(), contentEntity, likeEntity.getCreationDate());
            this.edgeIndexManager.index(likeEdge);
        }
    }

    private void addContentToIndex(List<ContentEntityObject> contentEntities) {
        for (ContentEntityObject contentEntity : contentEntities) {
            try {
                Edge edge;
                if (!this.edgeFactory.canBuildCreatEdge(contentEntity) || (edge = this.edgeFactory.getCreateEdge(contentEntity)) == null) continue;
                this.edgeIndexManager.index(edge);
            }
            catch (Exception e) {
                log.debug("Error building edge for: " + contentEntity);
            }
        }
    }

    private List<Object[]> getLikesSince(Date startDate) {
        Query query = this.entityManagerProvider.getEntityManager().createQuery("select l.content, l from LikeEntity l where l.creationDate > :startDate");
        return query.setParameter("startDate", startDate, TemporalType.DATE).getResultList();
    }

    private List<ContentEntityObject> getContentCreatedSince(Date startDate) {
        TypedQuery query = this.entityManagerProvider.getEntityManager().createQuery("from ContentEntityObject content\nwhere content.originalVersion is null and\ncontent.contentStatus = 'current' and\n(type(content) = com.atlassian.confluence.pages.Page or\ntype(content) = com.atlassian.confluence.pages.BlogPost or\ntype(content) = com.atlassian.confluence.pages.Comment) and content.creationDate > :startDate", ContentEntityObject.class);
        return query.setParameter("startDate", startDate, TemporalType.DATE).getResultList();
    }
}

