/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dragdrop.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.AtlassianCoreException;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.user.User;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class DragAndDropResource {
    private UserAccessor userAccessor;
    private final String DRAG_AND_DROP_TIP_SETTING_KEY = "show-drag-and-drop-tip";

    public DragAndDropResource(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @POST
    @Path(value="tip/disable")
    @Consumes(value={"application/json"})
    public Response disableShowTip() {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences((User)AuthenticatedUserThreadLocal.get());
        try {
            userPreferences.setString("show-drag-and-drop-tip", "false");
        }
        catch (AtlassianCoreException e) {
            return Response.serverError().build();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="tip/setting")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getTipSetting() {
        UserPreferences userPreferences = this.userAccessor.getUserPreferences((User)AuthenticatedUserThreadLocal.get());
        String value = userPreferences.getString("show-drag-and-drop-tip") != null ? userPreferences.getString("show-drag-and-drop-tip") : "";
        return Response.status((Response.Status)Response.Status.OK).entity((Object)value).build();
    }
}

