/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dragdrop;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.model.links.DefaultLink;
import com.atlassian.confluence.content.render.xhtml.model.resource.DefaultEmbeddedImage;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.AttachmentResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.NamedResourceIdentifier;
import com.atlassian.confluence.content.render.xhtml.model.resource.identifiers.ResourceIdentifier;
import com.atlassian.confluence.content.service.DraftService;
import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.core.Beanable;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.ContentEntityManager;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.InputStreamAttachmentResource;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.AttachmentManager;
import com.atlassian.confluence.pages.Draft;
import com.atlassian.confluence.pages.DraftsTransitionHelper;
import com.atlassian.confluence.pages.FileUploadManager;
import com.atlassian.confluence.pages.attachments.AttachmentDataStreamSizeMismatchException;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.xhtml.api.EditorFormatService;
import com.atlassian.confluence.xhtml.api.EmbeddedImage;
import com.atlassian.confluence.xhtml.api.Link;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.core.util.FileSize;
import com.atlassian.plugins.capabilities.api.CapabilityService;
import com.atlassian.renderer.RenderContext;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableSet;
import com.opensymphony.webwork.ServletActionContext;
import com.opensymphony.webwork.interceptor.ServletRequestAware;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class UploadAction
extends ConfluenceActionSupport
implements Beanable,
ServletRequestAware {
    private static final Logger log = Logger.getLogger(UploadAction.class);
    private FileUploadManager fileUploadManager;
    private AttachmentManager attachmentManager;
    private CapabilityService capabilityService;
    private EditorFormatService editorFormatService;
    private ContentEntityManager contentEntityManager;
    private DraftService draftService;
    private long pageId;
    private long draftId;
    private long dragAndDropEntityId;
    private String filename;
    private String mimeType;
    private long size;
    private boolean minorEdit;
    private boolean withEditorPlaceholder = true;
    private String contentType;
    private boolean isVFMSupported;
    private final Map<String, Object> jsonResult = new HashMap<String, Object>(2);
    private HttpServletRequest httpServletRequest;
    private static final Set<String> SUPPORTED_IMAGE_EXTENSIONS = ImmutableSet.of((Object)"png", (Object)"gif", (Object)"jpg", (Object)"jpeg", (Object)"tiff", (Object)"bmp", (Object[])new String[0]);
    private static final Set<String> SUPPORTED_MULTIMEDIA_EXTENSIONS = ImmutableSet.of((Object)"rm", (Object)"ram", (Object)"mpeg", (Object)"mpg", (Object)"wmv", (Object)"wma", (Object[])new String[]{"mpeg", "swf", "mov", "mp4", "mp3", "avi"});
    private static final Set<String> ALWAYS_SUPPORTED_VFM_EXTENSIONS = ImmutableSet.of((Object)"mp3", (Object)"mp4");
    private static final Set<String> UNSUPPORTED_MULTIMEDIA_EXTENSIONS_IN_CLOUD = ImmutableSet.of((Object)"swf");

    public void validate() {
        long maxUploadSize;
        super.validate();
        if (StringUtils.isBlank((CharSequence)this.filename)) {
            this.addActionError("Filename cannot be null or blank.");
        }
        if (this.size > (maxUploadSize = this.settingsManager.getGlobalSettings().getAttachmentMaxSize())) {
            ServletActionContext.getResponse().setStatus(413);
            String error = "File of size " + FileSize.format((long)this.size) + " exceeds maximum upload limit of " + FileSize.format((long)maxUploadSize);
            this.addActionError(error);
        }
    }

    public String execute() throws Exception {
        try {
            ContentEntityObject content;
            if (this.pageId == 0L && (this.draftId > 0L || this.getAuthenticatedUser() == null)) {
                Draft draft;
                String draftSpaceKey;
                content = this.contentEntityManager.getById(this.draftId);
                if (content == null && this.getAuthenticatedUser() == null) {
                    content = this.draftService.findDraftForEditor(0L, DraftService.DraftType.PAGE, null);
                }
                if (content == null) {
                    String noDraftFoundMessage = "Expecting to find draft for the new piece of content being created but none found.";
                    log.debug((Object)("Expecting to find draft for the new piece of content being created but none found.[username = " + AuthenticatedUserThreadLocal.getUsername() + ", draftId = " + this.draftId + "]"));
                    throw new RuntimeException("Expecting to find draft for the new piece of content being created but none found.");
                }
                if (DraftsTransitionHelper.isLegacyDraft((ContentEntityObject)content) && StringUtils.isNotBlank((CharSequence)(draftSpaceKey = (draft = (Draft)content).getDraftSpaceKey())) && draftSpaceKey.toLowerCase().startsWith("%7e")) {
                    draft.setDraftSpaceKey("~" + draftSpaceKey.substring(3));
                }
            } else if (this.pageId != 0L) {
                content = this.contentEntityManager.getById(this.pageId);
            } else if (this.dragAndDropEntityId != 0L) {
                content = this.contentEntityManager.getById(this.dragAndDropEntityId);
            } else {
                throw new RuntimeException("No valid pageId or draftType specified for this action.");
            }
            if (!this.permissionManager.hasCreatePermission((User)this.getAuthenticatedUser(), (Object)content, Attachment.class)) {
                String attachNotPermitted = "You'll need to ask permission to insert files here.";
                this.addActionError("You'll need to ask permission to insert files here.");
                log.debug((Object)"You'll need to ask permission to insert files here.");
                ServletActionContext.getResponse().setStatus(403);
                return "error";
            }
            InputStream inStream = this.getStreamForEncoding(this.httpServletRequest);
            this.fileUploadManager.storeResource((AttachmentResource)new InputStreamAttachmentResource(inStream, this.filename, this.mimeType, this.size, null, this.minorEdit), content);
            if (this.withEditorPlaceholder) {
                this.jsonResult.put("htmlForEditor", this.getHtmlToEmbedFileIntoEditorContent(this.filename, content));
            }
            this.jsonResult.put("data", this.getDetails(this.filename, content));
        }
        catch (AttachmentDataStreamSizeMismatchException e) {
            if (e.getActualSize() < e.getExpectedSize()) {
                String message = "Upload of " + this.filename + " has been cancelled by the client.";
                log.debug((Object)message);
                this.addActionError(message);
            }
            ServletActionContext.getResponse().setStatus(500);
            log.debug((Object)"Client attempted to upload a file with a content length smaller than the actual size of the file.");
            return "error";
        }
        catch (XhtmlException e) {
            ServletActionContext.getResponse().setStatus(500);
            this.addActionError(e.getMessage());
            log.error((Object)"Failed to generate html to embed dragged resource into content", (Throwable)e);
            return "error";
        }
        catch (RuntimeException e) {
            ServletActionContext.getResponse().setStatus(500);
            this.addActionError(e.getMessage());
            log.error((Object)"Failed to save file.", (Throwable)e);
            return "error";
        }
        return "success";
    }

    private InputStream getStreamForEncoding(HttpServletRequest request) throws UnsupportedEncodingException, IOException {
        String encoding = request.getHeader("Content-Encoding");
        ServletInputStream requestStream = request.getInputStream();
        if (encoding == null || encoding.isEmpty()) {
            return requestStream;
        }
        if (encoding.equals("base64")) {
            return new Base64InputStream((InputStream)requestStream);
        }
        throw new UnsupportedEncodingException(encoding + " is not supported");
    }

    private Map<String, String> getDetails(String fileName, ContentEntityObject content) {
        HashMap<String, String> data = new HashMap<String, String>();
        Attachment attachment = this.attachmentManager.getAttachment(content, fileName);
        data.put("id", String.valueOf(attachment.getId()));
        data.put("src", attachment.getDownloadPath());
        data.put("ownerId", String.valueOf(content.getId()));
        return data;
    }

    String getHtmlToEmbedFileIntoEditorContent(String filename, ContentEntityObject content) throws XhtmlException {
        String editorHtml;
        String extension = StringUtils.substringAfterLast((String)filename, (String)".").toLowerCase();
        AttachmentResourceIdentifier attachmentResourceIdentifier = new AttachmentResourceIdentifier(filename);
        DefaultConversionContext conversionContext = new DefaultConversionContext((RenderContext)content.toPageContext());
        if (SUPPORTED_IMAGE_EXTENSIONS.contains(extension)) {
            editorHtml = this.editorFormatService.convertEmbeddedImageToEdit((EmbeddedImage)new DefaultEmbeddedImage((NamedResourceIdentifier)attachmentResourceIdentifier), (ConversionContext)conversionContext);
        } else {
            boolean supportedMultimedia = SUPPORTED_MULTIMEDIA_EXTENSIONS.contains(extension);
            boolean shouldUseViewFileMacro = false;
            if (this.isVFMSupported) {
                boolean alwaysSupportedInVfm = ALWAYS_SUPPORTED_VFM_EXTENSIONS.contains(extension);
                boolean supportedInCloud = !UNSUPPORTED_MULTIMEDIA_EXTENSIONS_IN_CLOUD.contains(extension);
                boolean cloudConversionsEnabled = this.capabilityService.getHostApplication().hasCapability("file.conversions.cloud");
                boolean bl = cloudConversionsEnabled ? supportedInCloud : (shouldUseViewFileMacro = alwaysSupportedInVfm || !supportedMultimedia);
            }
            if (shouldUseViewFileMacro) {
                editorHtml = this.getMacroHtml("view-file", this.getVFMPlaceholderParams(filename), conversionContext, false);
            } else {
                String macro = supportedMultimedia ? "multimedia" : (extension.contains("doc") ? "viewdoc" : (extension.contains("xls") ? "viewxls" : (extension.contains("ppt") ? "viewppt" : (extension.equals("pdf") ? "viewpdf" : null))));
                editorHtml = macro != null ? this.getMacroHtml(macro, Collections.singletonMap("name", filename), conversionContext) : this.editorFormatService.convertLinkToEdit((Link)new DefaultLink((ResourceIdentifier)attachmentResourceIdentifier, null), (ConversionContext)conversionContext);
            }
        }
        return editorHtml;
    }

    private String getMacroHtml(String macroName, Map<String, String> params, DefaultConversionContext conversionContext) throws XhtmlException {
        return this.getMacroHtml(macroName, params, conversionContext, true);
    }

    private String getMacroHtml(String macroName, Map<String, String> params, DefaultConversionContext conversionContext, boolean insertNewLineAfter) throws XhtmlException {
        return this.editorFormatService.convertMacroDefinitionToEdit(MacroDefinition.builder((String)macroName).withParameters(params).withStorageVersion("1").build(), (ConversionContext)conversionContext) + (insertNewLineAfter ? "<br/>" : "");
    }

    private Map<String, String> getVFMPlaceholderParams(String filename) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", filename);
        String height = "250";
        if ("comment".equals(this.contentType)) {
            height = "150";
        }
        params.put("height", height);
        return params;
    }

    public Object getBean() {
        return this.jsonResult;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setMinorEdit(boolean minorEdit) {
        this.minorEdit = minorEdit;
    }

    public void setWithEditorPlaceholder(boolean withEditorPlaceholder) {
        this.withEditorPlaceholder = withEditorPlaceholder;
    }

    public void setServletRequest(HttpServletRequest httpServletRequest) {
        this.httpServletRequest = httpServletRequest;
    }

    public void setFileUploadManager(FileUploadManager fileUploadManager) {
        this.fileUploadManager = fileUploadManager;
    }

    public void setAttachmentManager(AttachmentManager attachmentManager) {
        this.attachmentManager = attachmentManager;
    }

    public void setCapabilityService(CapabilityService capabilityService) {
        this.capabilityService = capabilityService;
    }

    public void setPageId(long pageId) {
        this.pageId = pageId;
    }

    public void setDraftId(long draftId) {
        this.draftId = draftId;
    }

    public void setEditorFormatService(EditorFormatService editorFormatService) {
        this.editorFormatService = editorFormatService;
    }

    public void setDraftService(DraftService draftService) {
        this.draftService = draftService;
    }

    public void setDragAndDropEntityId(long dragAndDropEntityId) {
        this.dragAndDropEntityId = dragAndDropEntityId;
    }

    public void setContentEntityManager(ContentEntityManager contentEntityManager) {
        this.contentEntityManager = contentEntityManager;
    }

    public Map<String, Object> getJsonResult() {
        return this.jsonResult;
    }

    public void setIsVFMSupported(boolean isVFMSupported) {
        this.isVFMSupported = isVFMSupported;
    }
}

