// TAINTED: relying on the following indirectly:
//  * $.fn.spin from com.atlassian.auiplugin:aui-experimental-spinner
//  * $.fn.favourites from core:favourites.js
//  * Confluence.SpaceBlueprint.Dialog
//  * Confluence.Binder.userHover
define("confluence-dashboard-macros/entity-tabs", [
    "ajs",
    "jquery",
    "confluence/legacy"
], function(
    AJS,
    $,
    Confluence
) {
    "use strict";

    // If the tab hasn't yet been loaded, we pop a spinner on it and grab the contents via AJAX.
    var $globalEntities = $(".aui-tabs.global-entities");
    $globalEntities.on("tabSelect", "a", function(ev, tabData) {
        if (!tabData.pane.hasClass("content-loaded")) {
            tabData.pane
                .find(".loading-spinner")
                .spin("large");

            var contentUrl = tabData.pane.data("tab-content-url");

            $.get(AJS.contextPath() + contentUrl).then(function(content) {
                tabData.pane
                    .html(content);

                // Rebind 'favourites' stuff - this is for space/page tabs.
                tabData.pane.find(".entity-favourites").favourites({});

                // Rebind follow user box - this is for network tab.
                tabData.pane.find(".follow-user").followUser();

                // Rebind user-hovers - this is for network tab.
                Confluence.Binder.userHover();

                tabData.pane.addClass("content-loaded");

                // HACK: confluence-create-content-plugin generally binds these links, but only does it on page init
                // and has no binder available.
                tabData.pane.find("#spaces-pane-add-link").on("click", function() {
                    Confluence.SpaceBlueprint.Dialog.launch();
                    return false;
                });
            });
        }
    });
    $globalEntities.attr('data-ready-for-interaction', "true");
});
