define('confluence-dashboard-macros/dashboard-resource-loader', [
    'jquery',
    'wrm'
], function(
    $,
    WRM
) {
    'use strict';

    var dashboardResources = [];
    var oldDashboardResource = 'wr!confluence.macros.dashboard:dashboard-macros-resources';
    var globalEntityResource = 'wr!confluence.macros.dashboard:dashboard-global-entity-resources';

    return function() {
        //if old dashboard panel on page, load old dashboard
        if($('#recent-updates .tabs-menu').length || $('.spaceList').length) {
            dashboardResources.push(oldDashboardResource);
        }

        //if global entity on page, load those
        if($('#spaces-tab-link').length) {
            dashboardResources.push(globalEntityResource);
        }

        if (dashboardResources.length !== 0) {
            WRM.require(dashboardResources).done(function () {
                if (dashboardResources.indexOf(oldDashboardResource) > -1) {
                    var dashboardMacros = require('confluence-dashboard-macros/dashboard-macros');
                    dashboardMacros($);
                }
                if (dashboardResources.indexOf(globalEntityResource) > -1) {
                    require('confluence-dashboard-macros/entity-tabs');
                }
            });
        }
    };
});

require('confluence/module-exporter').safeRequire('confluence-dashboard-macros/dashboard-resource-loader', function(DashboardResourceLoader) {
    var AJS = require('ajs');
    AJS.toInit(DashboardResourceLoader);
});