// TODO: CONFDEV-26456 a *lot* of this stuff shouldn't exist anymore - the dashboard itself defers to
// AJS.Confluence.Binder.favourites and so the Space List macro really should too. This most of this code can go away.
define('confluence-dashboard-macros/dashboard-macros', [
    'ajs',
    'confluence/legacy',
    'window'
], function(
    AJS,
    Confluence,
    window
) {
    'use strict';

    return function($) {

        var waiting = []; // used to prevent the user from triggering off another labelling operation when one is in progress
        var contextPath = AJS.Meta.get("context-path");
        var UPDATES_REST_URL = contextPath + '/rest/dashboardmacros/1.0';

        var recentUpdatesAjaxConnection; // holds the ajax obj so we can abort it;

        // Space List Macro JS:

        /**
         * Check whether a space is favourited given the favourite icon for that space
         * @param button the space's favourite icon (jQuery object)
         */
        var spaceIsFavourited = function(button) {
            return button.hasClass("icon-remove-fav"); // Anchor version
        };

        /**
         * Add/Remove a space from the user's favourites. This is used when displaying spaces on the dashboard (in dash macros).
         * @param spaceKey - The space key of the space to add as favourite
         * @param button - The button that was clicked (anchor element jQuery object)
         */
        var toggleFavouriteSpace = function(spaceKey, button) {
            var wasFavourited = spaceIsFavourited(button);
            var waitIndicator = button.parent().find(".icon-wait");
            var url = contextPath + "/json/" +
                    (wasFavourited ? "removespacefromfavourites.action" : "addspacetofavourites.action");

            button.addClass("hidden");
            waitIndicator.removeClass("hidden");

            AJS.safe.ajax({
                url: url,
                type: "POST",
                data: { "key" : spaceKey },
                success: function(labelsArr) {
                    waitIndicator.addClass("hidden");
                    button.parent().find(wasFavourited? ".icon-add-fav" : ".icon-remove-fav").removeClass("hidden");
                    delete waiting[spaceKey];
                },
                error: function(xhr, text, error) {
                    // TODO CONF-20780 Notify the user of the problem (will need to be internationalised)
                    waitIndicator.addClass("hidden");
                    button.parent().find(wasFavourited? ".icon-remove-fav" : ".icon-add-fav").removeClass("hidden");
                    AJS.logError("Error Toggling Favourite Space: " + text);
                    delete waiting[spaceKey];
                }
            });
        };

        /**
         * If the user switches tabs while spaces are still being labelled, this function will prevent this from
         * happening. Allowing a location change in the middle of xmlhttp requests causes exceptions to be thrown in
         * Firefox (although, they seem to be ignored by IE). This is important in high latency environments where
         * users may get impatient.
         */
        var gotoUrl = function(url) {
            if ($.isEmptyObject(waiting)) {
                // DO NOTHING
                return;
            }
            window.location = url;
        };

        // FIXME: this code seems to not being in use anymore
        // Override AUI tab click behaviour for spaces list because we don't preload tab content as AUI expects
        $(".spaceList.aui-tabs ul.tabs-menu").undelegate("a", "click");

        $(".spaceList .tabs a").click(function() {
            gotoUrl(this.href);
            return false;
        });

        // FIXME: duplicated code - see entity-tabs.js
        $(".spaceList").delegate(".icon-add-fav, .icon-remove-fav", "click", function(e) {
            var button = $(e.target);
            var spaceKey = button.closest("tr").attr("data-space-key");
            if (waiting[spaceKey]) {
                AJS.log("Already busy toggling favourite space for '" + spaceKey + "'. Ignoring request.");
                return;
            }
            waiting[spaceKey] = true;
            toggleFavouriteSpace(spaceKey, button);
            return false;
        });

        $(".spaceList select.selectedTeam").change(function() {
            var dropDown = $(this);
            var baseUrl = dropDown.attr("data-base-url");
            var selectedTab = dropDown.attr("data-selected-tab");
            window.location = baseUrl + 'spacesSelectedTab=' + encodeURIComponent(selectedTab)
                    + '&spacesSelectedTeam=' + encodeURIComponent(this.value);
        });

        var eventPrefix = "confluence.dashboard.";

        var track = function(name, data) {
            AJS.trigger('analytics', { name: eventPrefix + name, data: data || {} });
        };

        // utility function that replaces spaces by - and returns a lower case string
        var dasherize = function(text) {
            return text.toLowerCase().replace(/\s/g, '-');
        };


        // Dashboard Recently Updated Content Macro JS:

        var $recentUpdates = $("#recent-updates");
        var $recentUpdatesTabMenu = $recentUpdates.find("ul.tabs-menu");
        var $container = $recentUpdates.find(".tabs-pane.active-pane");
        var $showMoreLessButtonContainer = $recentUpdatesTabMenu.find(".tabletitleops");

        var getPageSize = function() {
            return parseInt($recentUpdates.attr("data-num-updates"), 10);
        };

        var setPageSize = function(newPageSize) {
            return $recentUpdates.attr("data-num-updates", newPageSize);
        };

        var getUpdatesStepSize = function() {
            return parseInt($recentUpdates.attr("data-updates-step-size"), 10);
        };

        var getMinPageSize = function() {
            return parseInt($recentUpdates.attr("data-min-updates"), 10);
        };

        var getMaxPageSize = function() {
            return parseInt($recentUpdates.attr("data-max-updates"), 10);
        };

        var getActiveTab = function() {
            return $recentUpdatesTabMenu.find("li.active-tab");
        };

        var getActiveTabKey = function() {
            return getActiveTab().attr("data-tab-key");
        };

        var getSelectedCategory = function() {
            var $categorySelect = $recentUpdates.find("#updatesSelectedCategory");
            return $categorySelect.length > 0 ? $categorySelect.val() : "";
        };

        var fetchPopularContent = function() {
            // The popular tab handles its own content sizing
            $showMoreLessButtonContainer.hide();
            Confluence.Dashboard.reloadPopularStream();
            // Set the popular tab as the default
            if (recentUpdatesAjaxConnection && recentUpdatesAjaxConnection.abort) {
                recentUpdatesAjaxConnection.abort();
            }

            recentUpdatesAjaxConnection = $.ajax({
                url: UPDATES_REST_URL + '/default',
                type: 'PUT',
                data: {
                    tab: 'popular'
                }
            });
        };

        /**
         * CONFDEV-33536 - Confluence simplify journeys
         *
         *  Click on a item of any stream should trigger the following events:
         *
         *  - confluence.dashboard.popular-stream.item.click
         *  - confluence.dashboard.my-spaces-stream.item.click
         *  - confluence.dashboard.all-stream.item.click
         *  - confluence.dashboard.network-stream.item.click
         *  - confluence.dashboard.team-stream.item.click
         *
         *  Note: if a new tab is added, it will be triggered. All you need to do is add to the whitelist
         */
        $recentUpdates.on('click', '.tabs-pane a', function () {
            var context = getActiveTab().data('tabKey') + '-stream';

            track(context + '.item.click');
        });

        var fetchUpdatesClickHandler = function() {
            var activeTabKey = getActiveTabKey();

            if (activeTabKey === "popular") {
                fetchPopularContent();
                return;
            }

            var selectedCategory = getSelectedCategory();
            Confluence.Dashboard.showSpinner($container);
            $showMoreLessButtonContainer.show();

            var showProfilePic = ($recentUpdates.attr("data-show-profile-pic") === "true");
            var showSpaceName = ($recentUpdates.attr("data-show-space-name") === "true");
            var maxUpdates = getPageSize();

            var jsonBody = {
                "maxResults": maxUpdates,
                "tab": activeTabKey,
                "showProfilePic": showProfilePic,
                "labels": $recentUpdates.attr("data-labels-filter") ? $recentUpdates.attr("data-labels-filter") : "",
                "spaces": $recentUpdates.attr("data-spaces-filter") ? $recentUpdates.attr("data-spaces-filter") : "",
                "users": $recentUpdates.attr("data-users-filter") ? $recentUpdates.attr("data-users-filter") : "",
                "types": $recentUpdates.attr("data-types-filter") ? $recentUpdates.attr("data-types-filter") : "",
                "category": selectedCategory,
                "spaceKey": AJS.Meta.get("space-key") ? AJS.Meta.get("space-key") : ""
            };

            if (recentUpdatesAjaxConnection && recentUpdatesAjaxConnection.abort) {
                recentUpdatesAjaxConnection.abort();
            }

            recentUpdatesAjaxConnection = $.ajax({
                type: "POST",
                url: UPDATES_REST_URL + "/updates",
                contentType: "application/json",
                dataType: "json",
                data: JSON.stringify(jsonBody)
            }).success(function (data) {
                // Ignore responses from the server if they don't match the currently selected tab so we don't have
                // concurrency issues.
                if (getActiveTabKey() !== data.tabKey) {
                    AJS.log("Ignoring response from server because selected tab is not " + data.tabKey);
                    return;
                }

                $container.html(Confluence.Templates.Dashboard.Updates.updates({
                    contextPath: contextPath,
                    staticResourceUrlPrefix: AJS.params.staticResourceUrlPrefix,
                    currentUsername: AJS.params.remoteUser,
                    maxUpdates: maxUpdates,
                    selectedTab: activeTabKey,
                    viewableCategories: data.viewableCategories,
                    selectedCategory: data.selectedCategory,
                    showProfilePic: showProfilePic,
                    showSpaceName: showSpaceName,
                    changeSets: data.changeSets,
                    noContentMessage: data.noContentMessage
                }));

                Confluence.Binder.userHover();
                bindCategorySelector();
            }).error(function(jqXHR, textStatus, errorThrown) {
                $recentUpdates.find(".tabs-pane.active-pane").empty();
                AJS.log("Failed to retrieve updates. Status: " + textStatus + ", Error: " + errorThrown);
                AJS.messages.error("#recent-updates .tabs-pane.active-pane", {
                    title: AJS.I18n.getText("updates.retrieve.failed.title"),
                    body: "<p>" + AJS.I18n.getText("updates.retrieve.failed.description") + "</p>",
                    closeable: false
                });
            });
        };

        var updatePageSize = function(newPageSize) {
            var stepSize = getUpdatesStepSize();
            var minPageSize = getMinPageSize();
            var maxPageSize = getMaxPageSize();

            var $moreButton = $recentUpdatesTabMenu.find(".icon-show-more");
            var $lessButton = $recentUpdatesTabMenu.find(".icon-show-less");
            var moreButtonPageSize = (newPageSize + stepSize);
            var lessButtonPageSize = (newPageSize - stepSize);

            setPageSize(newPageSize);
            $moreButton.attr("href", $moreButton.attr("href").replace(/[\?\&]maxRecentlyUpdatedPageCount=\d+/, "maxRecentlyUpdatedPageCount=" + moreButtonPageSize));
            $lessButton.attr("href", $lessButton.attr("href").replace(/[\?\&]maxRecentlyUpdatedPageCount=\d+/, "maxRecentlyUpdatedPageCount=" + lessButtonPageSize));
            if (moreButtonPageSize > maxPageSize) {
                $moreButton.addClass("disabled");
            } else {
                $moreButton.removeClass("disabled");
            }
            if (lessButtonPageSize < minPageSize) {
                $lessButton.addClass("disabled");
            } else {
                $lessButton.removeClass("disabled");
            }
        };

        var bindCategorySelector = function() {
            $recentUpdates.find('select[name="updatesSelectedTeam"]').change(function() {
                fetchUpdatesClickHandler();
            });
        };

        // Override AUI tab click behaviour for recent updates because we don't preload tab content as AUI expects
        // and because we have other links (+/-) in the tab menu that AUI shouldn't handle
        $recentUpdatesTabMenu.undelegate("a", "click");

        // AJAX switch tab binding
        $recentUpdatesTabMenu.delegate("li.menu-item a", "click", function(e) {
            e.preventDefault();
            // Don't do anything if the user clicks on the active tab
            var $clickedTab = $(this).parent("li");
            if ($clickedTab.hasClass("active-tab")) {
                return;
            }

            // display the loading message so we're not at any point showing another tab's content in this tab
            Confluence.Dashboard.showSpinner($container);

            var $activeTab = getActiveTab();
            $activeTab.removeClass("active-tab");
            $clickedTab.addClass("active-tab");
            fetchUpdatesClickHandler();

            // CONFDEV-33536 - Confluence simplify journeys
            // sends the clicked tab name
            track('streams.item.click', {
                tab: $clickedTab.data('tabKey')
            });
        });

        // AJAX page size bindings
        $recentUpdatesTabMenu.find(".icon-show-less").click(function(e) {
            e.preventDefault();
            if ($(this).hasClass("disabled")) {
                return;
            }

            updatePageSize(getPageSize() - getUpdatesStepSize());
            fetchUpdatesClickHandler();
        });
        $recentUpdatesTabMenu.find(".icon-show-more").click(function(e) {
            e.preventDefault();
            if ($(this).hasClass("disabled")) {
                return;
            }

            updatePageSize(getPageSize() + getUpdatesStepSize());
            fetchUpdatesClickHandler();
        });

        // Twixie for thumbnails
        $recentUpdates.delegate("li.update-item .update-item-icons .update-item-arrow", "click", function(e) {
            var thumbnailId = $(e.currentTarget).attr("data-thumbnail-id");
            $('#twixie-' + thumbnailId).toggleClass("icon-section-opened icon-section-closed");
            $('#thumbnail-' + thumbnailId).toggle("fast");
            return false;
        });


        bindCategorySelector();

        var $globalEntitiesWidget = $('.global-entities');
        /**
         * CONFDEV-33536 - Confluence simplify journeys
         *
         *  Global entities refers to the small widget on the bottom left of the dashboard;
         *
         *  It triggers the following events:
         *
         *  - confluence.dashboard.spaces.click
         *  - confluence.dashboard.site-spaces.space.click
         *  - confluence.dashboard.site-spaces.space-directory.click
         *  - confluence.dashboard.favourite-spaces.space.click
         *  - confluence.dashboard.pages.click
         *  - confluence.dashboard.pages.favourite-page.click
         *  - confluence.dashboard.network.click
         *  - confluence.dashboard.network.following.add
         *  - confluence.dashboard.network.following.click
         *  - confluence.dashboard.network.follower.click
         */

            // click in a tab of the space widget
        $globalEntitiesWidget.on('click', '.tabs-menu a', function (e) {
            var context = dasherize(e.target.innerText);
            track(context + '.click');
        });

        // click in a space (space widget)
        $globalEntitiesWidget.on('click', '.global-spaces-section .space-name', function () {
            track('site-spaces.space.click');
        });

        // click the link to space directory (space widget)
        $globalEntitiesWidget.on('click', '.global-spaces-section .more-entities a', function () {
            track('site-spaces.space-directory.click');
        });

        // click in a favourite space (space widget)
        $globalEntitiesWidget.on('click', '.favourite-spaces-section .space-name', function () {
            track('favourite-spaces.space.click');
        });

        // click in a page (space widget)
        $globalEntitiesWidget.on('click', '.page-name', function () {
            track('pages.favourite-page.click');
        });

        var $networkSection = $('#network-pane');
        // network add
        $networkSection.on('click', '[type=submit]', function () {
            track('network.following.add');
        });

        // following click
        $networkSection.on('click', '.follow-following .userLogoLink', function () {
            track('network.following.click');
        });

        // follower click
        $networkSection.on('click', '.follow-followers .userLogoLink', function () {
            track('network.follower.click');
        });

        $recentUpdates.attr("data-ready-for-interaction", "true");
    };
});
