/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.dashboard.recentupdates;

import com.atlassian.confluence.internal.follow.FollowManagerInternal;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.plugins.macros.dashboard.recentupdates.tabs.AllContentTab;
import com.atlassian.confluence.plugins.macros.dashboard.recentupdates.tabs.FavouriteSpacesTab;
import com.atlassian.confluence.plugins.macros.dashboard.recentupdates.tabs.NetworkTab;
import com.atlassian.confluence.plugins.macros.dashboard.recentupdates.tabs.PopularTab;
import com.atlassian.confluence.plugins.macros.dashboard.recentupdates.tabs.RecentlyUpdatedMacroTab;
import com.atlassian.confluence.plugins.macros.dashboard.recentupdates.tabs.SpaceCategoryTab;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.web.context.HttpContext;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.InitializingBean;

public class RecentlyUpdatedMacroTabProvider
implements InitializingBean {
    private final LabelManager labelManager;
    private final PermissionManager permissionManager;
    private final FollowManagerInternal followManager;
    private final SpaceManager spaceManager;
    private final UserAccessor userAccessor;
    private final HttpContext httpContext;
    private final I18NBeanFactory i18NBeanFactory;
    private Map<String, RecentlyUpdatedMacroTab> availableTabs = Maps.newLinkedHashMap();
    private RecentlyUpdatedMacroTab defaultTab;
    private LocaleManager localeManager;

    public RecentlyUpdatedMacroTabProvider(SpaceManager spaceManager, LabelManager labelManager, PermissionManager permissionManager, FollowManagerInternal followManager, UserAccessor userAccessor, HttpContext httpContext, I18NBeanFactory i18NBeanFactory, LocaleManager localeManager) {
        this.spaceManager = spaceManager;
        this.labelManager = labelManager;
        this.permissionManager = permissionManager;
        this.followManager = followManager;
        this.userAccessor = userAccessor;
        this.httpContext = httpContext;
        this.i18NBeanFactory = i18NBeanFactory;
        this.localeManager = localeManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.defaultTab = new PopularTab(this.httpContext, this.i18NBeanFactory, this.localeManager);
        this.setAvailableTabs(this.defaultTab, new AllContentTab(this.httpContext, this.i18NBeanFactory, this.localeManager), new FavouriteSpacesTab(this.httpContext, this.i18NBeanFactory, this.labelManager, this.permissionManager, this.localeManager), new NetworkTab(this.httpContext, this.i18NBeanFactory, this.followManager, this.localeManager), new SpaceCategoryTab(this.httpContext, this.i18NBeanFactory, this.labelManager, this.permissionManager, this.spaceManager, this.userAccessor, this.localeManager));
    }

    private void setAvailableTabs(RecentlyUpdatedMacroTab ... tabs) {
        for (RecentlyUpdatedMacroTab tab : tabs) {
            this.availableTabs.put(StringUtils.lowerCase((String)tab.getName()), tab);
        }
    }

    public List<RecentlyUpdatedMacroTab> getAvailableTabs() {
        return ImmutableList.copyOf(this.availableTabs.values());
    }

    public RecentlyUpdatedMacroTab getTabByName(String name) {
        String normalisedName = StringUtils.lowerCase((String)name);
        if (!this.availableTabs.containsKey(normalisedName)) {
            return this.defaultTab;
        }
        return this.availableTabs.get(normalisedName);
    }

    public RecentlyUpdatedMacroTab getDefaultTab() {
        return this.defaultTab;
    }
}

