/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.dashboard;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.labels.SpaceLabelManager;
import com.atlassian.confluence.renderer.PageContext;
import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.SpaceManager;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.ServletActionContext;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpaceDetailsMacro
extends BaseMacro {
    public static final int ADMIN_LIMIT = 7;
    private static final Logger log = LoggerFactory.getLogger(SpaceDetailsMacro.class);
    private static final String MACRO_NAME = "space-details";
    private SpaceManager spaceManager;
    private SpaceLabelManager spaceLabelManager;

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        List adminUsers;
        Map<String, String> macroParameters = SpaceDetailsMacro.castMacroParams(parameters);
        String widthParameter = macroParameters.get("width");
        Map<String, Object> contextMap = this.getMacroVelocityContext();
        Space currentSpace = null;
        if (renderContext instanceof PageContext) {
            PageContext pageContext = (PageContext)renderContext;
            currentSpace = this.spaceManager.getSpace(pageContext.getSpaceKey());
        }
        ConfluenceActionSupport action = this.getWiredConfluenceActionSupport();
        HttpServletRequest request = ServletActionContext.getRequest();
        contextMap.put("dateFormatter", action.getDateFormatter());
        contextMap.put("i18NBean", action.getI18n());
        contextMap.put("req", request);
        contextMap.put("space", currentSpace);
        contextMap.put("webwork", new TextUtils());
        contextMap.put("teamLabels", this.spaceLabelManager.getTeamLabelsOnSpace(currentSpace.getKey()));
        boolean showAllAdmins = Boolean.valueOf(request.getParameter("showAllAdmins"));
        if (showAllAdmins) {
            adminUsers = this.spaceManager.getSpaceAdmins(currentSpace);
        } else {
            adminUsers = this.spaceManager.getSpaceAdmins(currentSpace, 8);
            if (adminUsers.size() > 7) {
                contextMap.put("moreAdmins", true);
                adminUsers = adminUsers.subList(0, 7);
            }
        }
        contextMap.put("admins", adminUsers);
        if (widthParameter != null) {
            contextMap.put("tableWidth", widthParameter);
        }
        try {
            return this.renderSpaceDetails(contextMap);
        }
        catch (Exception e) {
            log.error("Error while trying to load the space list template.", (Throwable)e);
            throw new MacroException((Throwable)e);
        }
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    protected Map<String, Object> getMacroVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    protected String renderSpaceDetails(Map contextMap) {
        return VelocityUtils.getRenderedTemplate((String)"com/atlassian/confluence/plugins/macros/dashboard/macro-viewspacedetails.vm", (Map)contextMap);
    }

    protected ConfluenceActionSupport getWiredConfluenceActionSupport() {
        return GeneralUtil.newWiredConfluenceActionSupport();
    }

    public String getName() {
        return MACRO_NAME;
    }

    public void setSpaceManager(SpaceManager spaceManager) {
        this.spaceManager = spaceManager;
    }

    public void setSpaceLabelManager(SpaceLabelManager spaceLabelManager) {
        this.spaceLabelManager = spaceLabelManager;
    }

    private static Map<String, String> castMacroParams(Map macroParams) {
        return macroParams;
    }
}

