/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.macros.dashboard;

import com.atlassian.confluence.renderer.radeox.macros.MacroUtils;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.velocity.VelocityUtils;
import com.atlassian.renderer.RenderContext;
import com.atlassian.renderer.v2.RenderMode;
import com.atlassian.renderer.v2.macro.BaseMacro;
import com.atlassian.renderer.v2.macro.MacroException;
import com.atlassian.user.User;
import com.opensymphony.webwork.ServletActionContext;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateSpaceButtonMacro
extends BaseMacro {
    public static final String MACRO_NAME = "create-space-button";
    private static final Logger log = LoggerFactory.getLogger(CreateSpaceButtonMacro.class);
    private PermissionManager permissionManager;

    public String execute(Map parameters, String body, RenderContext renderContext) throws MacroException {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.hasCreatePermission((User)currentUser, PermissionManager.TARGET_APPLICATION, Space.class)) {
            return "";
        }
        Map<String, String> macroParameters = CreateSpaceButtonMacro.castMacroParams(parameters);
        String sizeParameter = macroParameters.get("size");
        String heightParameter = macroParameters.get("height");
        String widthParameter = macroParameters.get("width");
        sizeParameter = sizeParameter == null ? "large" : sizeParameter.trim();
        if (heightParameter == null) {
            heightParameter = this.getSize(sizeParameter);
        }
        if (widthParameter == null) {
            widthParameter = this.getSize(sizeParameter);
        }
        Map<String, Object> contextMap = this.getMacroVelocityContext();
        contextMap.put("req", ServletActionContext.getRequest());
        contextMap.put("width", widthParameter);
        contextMap.put("height", heightParameter);
        contextMap.put("largeIcon", this.isLarge(sizeParameter));
        try {
            return this.renderButton(contextMap);
        }
        catch (Exception e) {
            log.error("Error while trying to load the create space button template.", (Throwable)e);
            throw new MacroException((Throwable)e);
        }
    }

    public boolean hasBody() {
        return false;
    }

    public RenderMode getBodyRenderMode() {
        return RenderMode.NO_RENDER;
    }

    protected Map<String, Object> getMacroVelocityContext() {
        return MacroUtils.defaultVelocityContext();
    }

    protected String renderButton(Map contextMap) {
        return VelocityUtils.getRenderedTemplate((String)"com/atlassian/confluence/plugins/macros/dashboard/createspacebutton.vm", (Map)contextMap);
    }

    private boolean isLarge(String sizeParameter) {
        return "large".equals(sizeParameter) || "\"large\"".equals(sizeParameter) || "'large'".equals(sizeParameter);
    }

    private String getSize(String sizeParameter) {
        return this.isLarge(sizeParameter) ? "32" : "16";
    }

    public String getName() {
        return MACRO_NAME;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    private static Map<String, String> castMacroParams(Map macroParams) {
        return macroParams;
    }
}

