define('confluence-dashboard/utils/strings', ['exports', 'module', 'jquery'], function (exports, module, _jquery) {
    'use strict';

    function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

    var _$ = _interopRequireDefault(_jquery);

    var CQL_NOT_ALLOWED = /[\+\-&\|!\(\)\{}\[\]\^~\*\?\\\/:"']/g;

    module.exports = {
        // strip special chars and spaces around
        normalizeForCQL: function normalizeForCQL(str) {
            return _$['default'].trim(str.replace(CQL_NOT_ALLOWED, ' '));
        }
    };
});
define('confluence-dashboard/modules/starred/starred-collection', ['exports', 'module', 'backbone', 'configuration', 'confluence-dashboard/utils/date-utils', '../../core/shared/cql-base-collection', 'ajs', 'jquery', 'underscore', '../../utils/date-utils'], function (exports, module, _backbone, _configuration, _confluenceDashboardUtilsDateUtils, _coreSharedCqlBaseCollection, _ajs, _jquery, _underscore, _utilsDateUtils) {
    'use strict';

    var context = _ajs.contextPath();

    var StarredModel = _backbone.Model.extend({
        url: _configuration.endpoints.ADD_FAVOURITE,
        url_destroy: _configuration.endpoints.REMOVE_FAVOURITE,

        defaults: {
            virtuallyDeleted: false
        },

        parse: function parse(response) {
            // the api expects entityId
            response.entityId = response.id;

            // attributes used for the UI/Templates
            response.url = context + response._links.webui;
            response.icon = response.type === 'page' ? 'page-default' : 'page-blogpost';

            var favouritedDate = response.metadata.currentuser.favourited.favouritedDate;
            response.favouritedDateISO = _confluenceDashboardUtilsDateUtils.toISODate(new Date(favouritedDate));

            return response;
        },

        // the current starred API has an endpoint for remove and another for adding stuff so we need to override the destroy method to call a different url  and use POST instead of deleting. Also, it needs the atl_token.

        // TODOs:
        // - [] refactor the api to a proper REST endpoint
        // - [] add a generic solution for sending atl_token
        destroy: function destroy() {
            return _backbone.Model.prototype.destroy.call(this, {
                dataType: 'json',
                data: _jquery.param({
                    entityId: this.get('entityId'),
                    atl_token: _ajs.Meta.get('atl-token')
                }),
                url: this.url_destroy,
                type: 'POST'
            });
        }
    });

    module.exports = _coreSharedCqlBaseCollection.extend({

        apiParams: {
            url: _configuration.endpoints.STARRED,

            params: {
                limit: _configuration.apiLimit
            },

            expansions: ['metadata.currentuser.favourited'],

            cql: 'favourite=currentUser()',

            cqlOrder: 'favourite desc'
        },

        model: StarredModel,

        groupMethod: function groupMethod(item) {
            return item.get('favouritedDateISO');
        },

        parse: function parse(data, options) {
            // for the case where lucene becomes out of sync with the favourite label,
            // remove items that don't have a favouriteDate
            data.results = _underscore.reject(data.results, function (result) {
                return !result.metadata.currentuser.favourited;
            });
            return _coreSharedCqlBaseCollection.prototype.parse.apply(this, arguments);
        }
    });
});
define('confluence-dashboard/modules/starred/starred-item-view', ['exports', 'module', '../list-item/list-item-view', '../../behaviors/undo-remove', '../../behaviors/list-item-animated', '../../behaviors/tooltips'], function (exports, module, _listItemListItemView, _behaviorsUndoRemove, _behaviorsListItemAnimated, _behaviorsTooltips) {
	'use strict';

	module.exports = _listItemListItemView.extend({
		templateHelpers: {
			removable: true
		},

		ui: {
			'tooltips': '.top-tooltip'
		},

		behaviors: {
			undoRemove: {
				behaviorClass: _behaviorsUndoRemove,
				eventNamespace: 'favourites'
			},

			tooltip: {
				behaviorClass: _behaviorsTooltips,
				selector: '.top-tooltip'
			},

			animated: {
				behaviorClass: _behaviorsListItemAnimated
			}
		}
	});
});
define('confluence-dashboard/modules/starred/starred-controller', ['exports', 'module', 'confluence-dashboard/core/content/content-as-grouped-list-view', 'confluence-dashboard/core/content/content-controller', './starred-collection', './starred-item-view', 'confluence-dashboard/soy-templates', 'configuration', 'ajs'], function (exports, module, _confluenceDashboardCoreContentContentAsGroupedListView, _confluenceDashboardCoreContentContentController, _starredCollection, _starredItemView, _confluenceDashboardSoyTemplates, _configuration, _ajs) {
    'use strict';

    module.exports = _confluenceDashboardCoreContentContentController.extend({
        actionsToFilter: ['starred'],

        // route: /starred
        starred: function starred() {
            this.view = new _confluenceDashboardCoreContentContentAsGroupedListView({
                collection: new _starredCollection(),
                templateHelpers: {
                    title: _ajs.I18n.getText('starred.title'),
                    contentType: this.options.name
                },
                childViewOptions: {
                    childView: _starredItemView
                },
                emptyViewOptions: {
                    template: _confluenceDashboardSoyTemplates.Starred.blank
                },
                className: 'default-list-view starred-list'

            });

            this.view.collection.fetch();
        }
    });
});
