define('confluence-dashboard/modules/recommended-stream/recommended-stream-collection', ['exports', 'module', 'underscore', '../../core/shared/cql-base-collection', 'backbone', 'configuration'], function (exports, module, _underscore, _coreSharedCqlBaseCollection, _backbone, _configuration) {
    'use strict';

    var RecommendedItemModel = _backbone.Model.extend({
        destroy: function destroy() {
            return _backbone.Model.prototype.destroy.call(this, {
                dataType: 'json',
                url: _configuration.endpoints.RECOMMENDED_STREAM + '/' + this.get('id'),
                type: 'DELETE'
            });
        }
    });

    module.exports = _coreSharedCqlBaseCollection.extend({
        url: _configuration.endpoints.RECOMMENDED_STREAM,
        model: RecommendedItemModel,

        parse: function parse(data, options) {
            this.parseNext(data, options);

            // inject data.model for each item
            var items = _underscore.map(data.streamItems, function (item) {
                item.model = data.model;
                return item;
            });

            return items;
        },

        // Used inside the parse method to detect if there is a next page. This follows the Atlassian REST response format and should be overwritten on your collection if you expect a different format of data.
        parseNext: function parseNext(data, options) {
            if (data.nextPageOffset) {
                this.hasNext = true;
                this.nextUrl = _configuration.endpoints.RECOMMENDED_STREAM + '?nextPageOffset=' + data.nextPageOffset;
            } else {
                this.hasNext = false;
                this.nextUrl = null;
            }
        }
    });
});
define('confluence-dashboard/modules/recommended-stream/recommended-stream-view', ['exports', 'module', 'marionette', 'confluence-dashboard/soy-templates', 'confluence/hover-user', '../../utils/analytics', 'configuration'], function (exports, module, _marionette, _confluenceDashboardSoyTemplates, _confluenceHoverUser, _utilsAnalytics, _configuration) {
    'use strict';

    module.exports = _marionette.ItemView.extend({
        template: _confluenceDashboardSoyTemplates.RecommendedStream.compactStreamItem,
        tagName: 'li',

        events: {
            'click a.stream-item-heading-link': 'onItemClick',
            'mousedown a.stream-item-heading-link': 'onItemClick',
            'click a.delete-button': 'onItemDelete'
        },

        className: function className() {
            return 'stream-item stream-item-layout ' + this.model.get('contentCssClass');
        },

        onDomRefresh: function onDomRefresh() {
            (0, _confluenceHoverUser)();
        },

        onItemClick: function onItemClick(event) {
            _utilsAnalytics.publish('recommended.item.clicked', {
                model: this.model.get('model') || '',
                id: this.model.get('id')
            });
        },

        onItemDelete: function onItemDelete(event) {
            this.model.destroy();
            _utilsAnalytics.publish('recommended.item.deleted', {
                model: this.model.get('model') || '',
                id: this.model.get('id')
            });
            event.preventDefault();
        }
    });
});
define("confluence-dashboard/modules/recommended-stream/recommended-stream-empty-view", ["exports"], function (exports) {
  "use strict";
});
define('confluence-dashboard/modules/recommended-stream/recommended-stream-controller', ['exports', 'module', './recommended-stream-collection', './recommended-stream-view', './recommended-stream-empty-view', 'confluence-dashboard/core/content/content-as-stream-view', 'confluence-dashboard/core/content/content-controller', 'confluence-dashboard/soy-templates', 'ajs'], function (exports, module, _recommendedStreamCollection, _recommendedStreamView, _recommendedStreamEmptyView, _confluenceDashboardCoreContentContentAsStreamView, _confluenceDashboardCoreContentContentController, _confluenceDashboardSoyTemplates, _ajs) {
    'use strict';

    module.exports = _confluenceDashboardCoreContentContentController.extend({
        actionsToFilter: ['recommendedStream'],

        recommendedStream: function recommendedStream() {
            this.view = new _confluenceDashboardCoreContentContentAsStreamView({
                collection: new _recommendedStreamCollection(),
                templateHelpers: {
                    title: "Recommended for you",
                    contentType: this.options.name
                },
                childView: _recommendedStreamView,
                emptyViewOptions: {
                    template: _confluenceDashboardSoyTemplates.RecommendedStream.blank
                }

            });

            this.view.collection.fetch();
        }
    });
});
