define("confluence-dashboard/modules/recently-worked/recently-worked-empty-view", ["exports"], function (exports) {
  "use strict";
});
define('confluence-dashboard/modules/recently-worked/recently-worked-collection', ['exports', 'module', 'backbone', 'configuration', 'confluence-dashboard/utils/date-utils', '../../core/shared/base-collection-with-function', 'underscore', 'ajs'], function (exports, module, _backbone, _configuration, _confluenceDashboardUtilsDateUtils, _coreSharedBaseCollectionWithFunction, _underscore, _ajs) {
    'use strict';

    var context = _ajs.contextPath();

    var RecentWorkedModel = _backbone.Model.extend({

        parse: function parse(response, options) {
            var time = response.metadata.currentuser.lastmodified.version.when;
            var dateObj = new Date(time);
            var timestamp = dateObj.getTime();

            _underscore.extend(response, {
                'url': context + response._links.webui,
                'date': time,
                timestamp: timestamp,
                lastModifiedISO: _confluenceDashboardUtilsDateUtils.toISODate(dateObj),
                'friendlyDate': 'Updated ' + time,
                'updated': time,
                'icon': response.type === 'page' ? 'page-default' : 'page-blogpost'
            });

            return response;
        }
    });

    module.exports = _coreSharedBaseCollectionWithFunction.extend({

        model: RecentWorkedModel,

        comparator: function comparator(modelA, modelB) {
            return -_confluenceDashboardUtilsDateUtils.compareTimestamps(modelA.get("timestamp"), modelB.get("timestamp"));
        },

        apiParams: function apiParams(options) {
            return {
                url: _configuration.endpoints.RECENTLY_WORKED,

                expansions: ['container', 'metadata.currentuser.lastmodified'],
                //in does not guarantee order so the sort comes back a little weird and needs to be sorted client side
                cql: 'type in (page,blogpost) and id in recentlyModifiedPagesAndBlogPostsByUser(currentUser(), ' + this.getPageOffset(options) + ', ' + this.getPageLimit(options) + ')'
            };
        },

        groupMethod: function groupMethod(item) {
            return item.get('lastModifiedISO');
        }
    });
});
define('confluence-dashboard/utils/strings', ['exports', 'module', 'jquery'], function (exports, module, _jquery) {
    'use strict';

    function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

    var _$ = _interopRequireDefault(_jquery);

    var CQL_NOT_ALLOWED = /[\+\-&\|!\(\)\{}\[\]\^~\*\?\\\/:"']/g;

    module.exports = {
        // strip special chars and spaces around
        normalizeForCQL: function normalizeForCQL(str) {
            return _$['default'].trim(str.replace(CQL_NOT_ALLOWED, ' '));
        }
    };
});
define('confluence-dashboard/modules/recently-worked/recently-worked-controller', ['exports', 'module', './recently-worked-empty-view', './recently-worked-collection', 'confluence-dashboard/core/content/content-as-grouped-list-view', 'confluence-dashboard/core/content/content-controller', 'confluence-dashboard/soy-templates', 'ajs'], function (exports, module, _recentlyWorkedEmptyView, _recentlyWorkedCollection, _confluenceDashboardCoreContentContentAsGroupedListView, _confluenceDashboardCoreContentContentController, _confluenceDashboardSoyTemplates, _ajs) {
    'use strict';

    module.exports = _confluenceDashboardCoreContentContentController.extend({
        actionsToFilter: ['recentWorked'],

        recentWorked: function recentWorked() {
            this.view = new _confluenceDashboardCoreContentContentAsGroupedListView({
                collection: new _recentlyWorkedCollection(),
                templateHelpers: {
                    title: _ajs.I18n.getText('recently.worked.title'),
                    contentType: this.options.name
                },
                emptyViewOptions: {
                    template: _confluenceDashboardSoyTemplates.RecentWorked.blank
                },
                className: 'default-list-view starred-list'
            });

            this.view.collection.fetch();
        }
    });
});
