define('confluence-dashboard/modules/recently-viewed/recently-viewed-collection', ['exports', 'module', 'backbone', 'configuration', 'confluence-dashboard/utils/date-utils', '../../core/shared/base-collection-with-function', 'underscore', 'ajs'], function (exports, module, _backbone, _configuration, _confluenceDashboardUtilsDateUtils, _coreSharedBaseCollectionWithFunction, _underscore, _ajs) {
    'use strict';

    var context = _ajs.contextPath();

    var RecentViewedModel = _backbone.Model.extend({

        parse: function parse(response, options) {
            var date = response.metadata.currentuser.viewed.lastSeen;
            var dateObj = new Date(date);
            var timestamp = dateObj.getTime();

            _underscore.extend(response, {
                'url': context + response._links.webui,
                'date': date,
                timestamp: timestamp,
                lastSeenISO: _confluenceDashboardUtilsDateUtils.toISODate(dateObj),
                'icon': response.type === 'page' ? 'page-default' : 'page-blogpost'
            });

            return response;
        }
    });

    module.exports = _coreSharedBaseCollectionWithFunction.extend({

        model: RecentViewedModel,

        comparator: function comparator(modelA, modelB) {
            return -_confluenceDashboardUtilsDateUtils.compareTimestamps(modelA.get("timestamp"), modelB.get("timestamp"));
        },

        apiParams: function apiParams(options) {
            return {
                url: _configuration.endpoints.RECENTLY_VIEWED,

                expansions: ['container', 'metadata.currentuser.viewed'],

                cql: 'id in recentlyViewedContent(' + this.getPageLimit(options) + ', ' + this.getPageOffset(options) + ')'
            };
        },

        groupMethod: function groupMethod(item) {
            return item.get('lastSeenISO');
        }
    });
});
define('confluence-dashboard/utils/strings', ['exports', 'module', 'jquery'], function (exports, module, _jquery) {
    'use strict';

    function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

    var _$ = _interopRequireDefault(_jquery);

    var CQL_NOT_ALLOWED = /[\+\-&\|!\(\)\{}\[\]\^~\*\?\\\/:"']/g;

    module.exports = {
        // strip special chars and spaces around
        normalizeForCQL: function normalizeForCQL(str) {
            return _$['default'].trim(str.replace(CQL_NOT_ALLOWED, ' '));
        }
    };
});
define('confluence-dashboard/modules/recently-viewed/recently-viewed-controller', ['exports', 'module', './recently-viewed-collection', 'confluence-dashboard/core/content/content-as-grouped-list-view', 'confluence-dashboard/core/content/content-controller', 'confluence-dashboard/soy-templates', 'configuration', 'ajs'], function (exports, module, _recentlyViewedCollection, _confluenceDashboardCoreContentContentAsGroupedListView, _confluenceDashboardCoreContentContentController, _confluenceDashboardSoyTemplates, _configuration, _ajs) {
    'use strict';

    module.exports = _confluenceDashboardCoreContentContentController.extend({
        actionsToFilter: ['recentViewed'],

        recentViewed: function recentViewed() {

            this.view = new _confluenceDashboardCoreContentContentAsGroupedListView({
                collection: new _recentlyViewedCollection(),
                templateHelpers: {
                    title: _ajs.I18n.getText('recently.viewed.title'),
                    contentType: this.options.name
                },
                emptyViewOptions: {
                    template: _confluenceDashboardSoyTemplates.RecentViewed.blank
                },
                className: 'default-list-view starred-list'
            });

            this.view.collection.fetch();
        }
    });
});
