define('confluence-dashboard/modules/popular-stream/popular-stream-collection', ['exports', 'module', '../../core/shared/cql-base-collection', 'backbone', 'configuration'], function (exports, module, _coreSharedCqlBaseCollection, _backbone, _configuration) {
    'use strict';

    module.exports = _coreSharedCqlBaseCollection.extend({
        url: _configuration.endpoints.POPULAR_STREAM,

        parse: function parse(data, options) {
            this.parseNext(data, options);
            return data.streamItems;
        },

        // Used inside the parse method to detect if there is a next page. This follows the Atlassian REST response format and should be overwritten on your collection if you expect a different format of data.
        parseNext: function parseNext(data, options) {
            if (data.nextPageOffset) {
                this.hasNext = true;
                this.nextUrl = _configuration.endpoints.POPULAR_STREAM + '&nextPageOffset=' + data.nextPageOffset;
            } else {
                this.hasNext = false;
                this.nextUrl = null;
            }
        }
    });
});
define('confluence-dashboard/modules/popular-stream/popular-stream-view', ['exports', 'module', 'marionette', 'confluence-dashboard/soy-templates', 'confluence/hover-user'], function (exports, module, _marionette, _confluenceDashboardSoyTemplates, _confluenceHoverUser) {
    'use strict';

    module.exports = _marionette.ItemView.extend({
        template: _confluenceDashboardSoyTemplates.PopularStream.compactStreamItem,
        tagName: 'li',
        className: function className() {
            return 'stream-item stream-item-layout ' + this.model.get('contentCssClass');
        },

        onDomRefresh: function onDomRefresh() {
            (0, _confluenceHoverUser)();
        }
    });
});
define("confluence-dashboard/modules/popular-stream/popular-stream-empty-view", ["exports"], function (exports) {
  "use strict";
});
define('confluence-dashboard/modules/popular-stream/popular-stream-controller', ['exports', 'module', './popular-stream-collection', './popular-stream-view', './popular-stream-empty-view', 'confluence-dashboard/core/content/content-as-stream-view', 'confluence-dashboard/core/content/content-controller', 'confluence-dashboard/soy-templates', 'ajs'], function (exports, module, _popularStreamCollection, _popularStreamView, _popularStreamEmptyView, _confluenceDashboardCoreContentContentAsStreamView, _confluenceDashboardCoreContentContentController, _confluenceDashboardSoyTemplates, _ajs) {
    'use strict';

    module.exports = _confluenceDashboardCoreContentContentController.extend({
        actionsToFilter: ['popularStream'],

        popularStream: function popularStream() {
            this.view = new _confluenceDashboardCoreContentContentAsStreamView({
                collection: new _popularStreamCollection(),
                templateHelpers: {
                    title: _ajs.I18n.getText('popular.stream.title'),
                    contentType: this.options.name
                },
                childView: _popularStreamView,
                emptyViewOptions: {
                    template: _confluenceDashboardSoyTemplates.PopularStream.blank
                }

            });

            this.view.collection.fetch();
        }
    });
});
