define('confluence-dashboard/modules/opt-out/opt-out-action-view', ['exports', 'module', '../../utils/event-manager', 'marionette', 'configuration', 'confluence-dashboard/soy-templates', '../../utils/dark-features', 'confluence/analytics-support', 'ajs', 'confluence/meta', 'underscore', 'jquery', 'window', '../../utils/ensure-component', '../../utils/analytics'], function (exports, module, _utilsEventManager, _marionette, _configuration, _confluenceDashboardSoyTemplates, _utilsDarkFeatures, _confluenceAnalyticsSupport, _ajs, _confluenceMeta, _underscore, _jquery, _window, _utilsEnsureComponent, _utilsAnalytics) {
    'use strict';

    var USER_DISABLED_DASHBOARD_DARK_FEATURE = _configuration.DARK_FEATURES.USER_DISABLED_DASHBOARD_DARK_FEATURE;

    var BTF_FLAVOUR = 'VANILLA';

    var ANALYTICS_PREFIX = 'opt-out';

    module.exports = _marionette.ItemView.extend({
        template: _confluenceDashboardSoyTemplates.OptOut.sidebarButton,

        className: 'sidebar-opt-out',

        initialize: function initialize() {
            // inline dialog isn't available by default.
            require(['aui/inline-dialog2']);
            this.isAuiFiveSeven = _ajs.version.indexOf('5.7') === 0;
        },

        shouldShow: function shouldShow() {
            return false;
        },

        addTo: function addTo(target) {
            var _this = this;

            (0, _jquery)(target).append(this.render().el);

            var inlineDialog = this.$('.opt-out-dialog');

            // Skate components are initialized asynchronous so we need to check if they are ready before
            // binding callbacks for click event on buttons.
            // There were issues about no event callbacks for buttons in most of browsers except for Chrome.
            // And this issue happened with AUI^5.9.
            (0, _utilsEnsureComponent)(inlineDialog[0]).then(function () {
                inlineDialog.find('.btn-send-feedback').on('click', _this.sendFeedback.bind(_this));
            });

            this.listenTo(_utilsEventManager.EventManager, 'sidebar:collapse', this.closeInlineDialog.bind(this));
            this.listenTo(_utilsEventManager.EventManager, 'window:scroll', this.closeInlineDialog.bind(this));

            this.inlineDialog = inlineDialog;
        },

        closeInlineDialog: function closeInlineDialog() {
            var _this2 = this;

            if (this.inlineDialog.length) {
                (0, _utilsEnsureComponent)(this.inlineDialog[0]).then(function () {
                    if (_this2.isAuiFiveSeven) {
                        _this2.inlineDialog.hide();
                    } else {
                        _this2.inlineDialog.open = false;
                    }
                });
            }
        },

        sendFeedback: function sendFeedback(e) {
            var _this3 = this;

            // Don't submit the form
            e.preventDefault();

            //reverse dark feature
            _utilsDarkFeatures.remotely.user.enable(USER_DISABLED_DASHBOARD_DARK_FEATURE).then(function () {
                return _this3.onDisableDashboard();
            });
        },

        onDisableDashboard: function onDisableDashboard() {
            var message = this.inlineDialog.find('[name=feedback]').val();

            _utilsAnalytics.publish(ANALYTICS_PREFIX + '.confirm', {
                message: message
            });

            _window.location = _ajs.contextPath();
        }
    });
});
define('confluence-dashboard/modules/opt-out/opt-out-controller', ['exports', './opt-out-action-view', '../../utils/module-starter', '../../utils/conditions', 'ajs'], function (exports, _optOutActionView, _utilsModuleStarter, _utilsConditions, _ajs) {
    'use strict';

    var initOptOut = function initOptOut() {
        var optOutView = new _optOutActionView({
            templateHelpers: {
                isAuiFiveSeven: _ajs.version.indexOf('5.7') === 0
            }
        });

        if (optOutView.shouldShow()) {
            optOutView.addTo('.aui-sidebar-footer');
        }
    };

    _ajs.toInit(function () {
        if (_utilsConditions.canShowDashboard()) {
            _utilsModuleStarter.register(initOptOut);
        }
    });
});

require(["confluence-dashboard/modules/opt-out/opt-out-controller"]);
