define('confluence-dashboard/modules/onboarding/onboarding-view', ['exports', 'module', '../../core/shared/base-dialog', 'confluence-dashboard/soy-templates', 'configuration', 'ajs', '../../utils/feature-discovery', 'underscore'], function (exports, module, _coreSharedBaseDialog, _confluenceDashboardSoyTemplates, _configuration, _ajs, _utilsFeatureDiscovery, _underscore) {
    'use strict';

    module.exports = _coreSharedBaseDialog.extend({
        attributes: {
            id: 'dashboard-onboarding-dialog',
            'aria-hidden': true
        },

        ui: {
            btnShow: '.show-onboarding',
            btnSkip: '.skip-onboarding'
        },

        events: {
            'click @ui.btnShow': 'showOnboarding',
            'click @ui.btnSkip': 'skipOnboarding'
        },

        initialize: function initialize() {
            this.featureDiscovery = _utilsFeatureDiscovery.forPlugin(_configuration.pluginKey);

            if (this.featureDiscovery.canShow('dialog')) {
                this.openDialog();
            } else {
                this.remove();
            }
        },

        onDestroy: function onDestroy() {
            this.featureDiscovery = null;
        },

        getTemplate: function getTemplate() {
            if (this.options.isNewUser) {
                return _confluenceDashboardSoyTemplates.Onboarding.newUser;
            }

            return _confluenceDashboardSoyTemplates.Onboarding.existingUser;
        },

        showOnboarding: function showOnboarding() {
            this.featureDiscovery.markDiscoveredSafe('dialog');
            this.closeDialog();

            if (this.options.onConfirm && _underscore.isFunction(this.options.onConfirm)) {
                this.options.onConfirm();
            }
        },

        skipOnboarding: function skipOnboarding() {
            this.featureDiscovery.markDiscoveredSafe('dialog');
            this.featureDiscovery.markDiscoveredSafe('tips');

            this.closeDialog();
        }
    });
});
define('confluence-dashboard/modules/onboarding/onboarding-tooltip-view', ['exports', 'module', 'marionette', 'configuration', 'ajs', 'underscore', 'jquery', '../../utils/feature-discovery', '../../utils/ensure-component', '../../utils/event-manager'], function (exports, module, _marionette, _configuration, _ajs, _underscore, _jquery, _utilsFeatureDiscovery, _utilsEnsureComponent, _utilsEventManager) {
    'use strict';

    module.exports = _marionette.ItemView.extend({

        className: 'onboarding-tooltip-wrapper',

        initialize: function initialize() {
            this.isAuiFiveSeven = _ajs.version.indexOf('5.7') === 0;
            this.featureDiscovery = _utilsFeatureDiscovery.forPlugin(_configuration.pluginKey);

            this.target = this.options.placedNextTo;
            this.tipId = this.options.tipId;

            this.addToScreen();
        },

        addToScreen: function addToScreen() {
            var _this = this;

            if (this.featureDiscovery.canShow(this.tipId)) {
                (function () {
                    (0, _jquery)(_this.target).append(_this.render().el);

                    var inlineDialog = _this.$('.onboarding-tooltips');

                    // Skate components are initialized asynchronous so we need to check if they are ready before
                    // binding callbacks for click event on buttons.
                    // There were issues about no event callbacks for buttons in most of browsers except for Chrome.
                    // And this issue happened with AUI^5.9 .
                    (0, _utilsEnsureComponent)(inlineDialog[0]).then(function () {
                        inlineDialog.find('.btn-next').on('click', _this.showNext.bind(_this));
                        inlineDialog.find('.btn-skip').on('click', _this.skipTooltips.bind(_this));
                    });

                    _this.listenTo(_utilsEventManager.EventManager, 'sidebar:collapse', _this.close.bind(_this));
                    _this.listenTo(_utilsEventManager.EventManager, 'window:scroll', _this.close.bind(_this));

                    _this.inlineDialog = inlineDialog[0];
                })();
            } else {
                this.destroy();
            }
        },

        open: function open() {
            var _this2 = this;

            // Skate components are initialized asynchronous so we need to check if they are ready before
            (0, _utilsEnsureComponent)(this.inlineDialog).then(function () {
                if (_this2.isAuiFiveSeven) {
                    _this2.inlineDialog.show();
                } else {
                    _this2.inlineDialog.open = true;
                }
            });
        },

        close: function close() {
            var _this3 = this;

            (0, _utilsEnsureComponent)(this.inlineDialog).then(function () {
                if (_this3.isAuiFiveSeven) {
                    _this3.inlineDialog.hide();
                } else {
                    _this3.inlineDialog.open = false;
                }
            });
        },

        showNext: function showNext() {
            this.featureDiscovery.markDiscovered(this.tipId);
            this.close();
            this.trigger('next', this);
            this.destroy();
        },

        skipTooltips: function skipTooltips() {
            this.trigger('skip', this);
        },

        onDestroy: function onDestroy() {
            var _this4 = this;

            // make sure we remove it from the DOM
            if (this.inlineDialog) {
                (0, _utilsEnsureComponent)(this.inlineDialog).then(function () {
                    return _this4.inlineDialog.remove();
                });
            }
        }
    });
});
define('confluence-dashboard/modules/onboarding/onboarding-tooltips-manager', ['exports', 'module', 'marionette', 'confluence-dashboard/soy-templates', './onboarding-tooltip-view', 'underscore', 'ajs', 'configuration', '../../utils/feature-discovery'], function (exports, module, _marionette, _confluenceDashboardSoyTemplates, _onboardingTooltipView, _underscore, _ajs, _configuration, _utilsFeatureDiscovery) {
    'use strict';

    module.exports = _marionette.Object.extend({
        initialize: function initialize() {
            // we still need to load inline-dialog2 manually
            require(['aui/inline-dialog2']);

            this.featureDiscovery = _utilsFeatureDiscovery.forPlugin(_configuration.pluginKey);
        },

        getTooltipDefinitions: function getTooltipDefinitions(data) {
            return [{
                element: '.sidebar-discover',
                tipId: 'tour-step-sidebar',
                template: _confluenceDashboardSoyTemplates.Onboarding[data.isNew ? 'newUserStep1' : 'existingUserStep1']
            }, {
                element: '.sidebar-spaces',
                tipId: 'tour-step-favourite-spaces',
                template: _confluenceDashboardSoyTemplates.Onboarding[data.isNew ? 'newUserStep2' : 'existingUserStep2']
            }];
        },

        showTips: function showTips(data) {
            var tourInlineDialogs = this.getTooltipDefinitions(data);

            this.createSteps(tourInlineDialogs);
        },

        createSteps: function createSteps(steps) {
            var _this = this;

            if (!steps) {
                return false;
            }
            // if 'tips' is marked as discovered, we don't show it
            if (!this.featureDiscovery.canShow('tips')) {
                return false;
            }

            this.steps = [];

            _underscore.each(steps, function (step) {
                // each specific tip can be marked as discovered. If it's true, we don't show it again
                if (_this.featureDiscovery.canShow(step.tipId)) {
                    // we add it to a list so we can perform batch operations later
                    _this.steps.push(_this.createTooltip(step));
                }
            });

            // the first one should be open
            this.openFirst();
        },

        createTooltip: function createTooltip(step) {
            var tooltip = new _onboardingTooltipView({
                tipId: step.tipId,
                placedNextTo: step.element,
                template: step.template,
                templateHelpers: {
                    id: step.tipId,
                    isAuiFiveSeven: _ajs.version.indexOf('5.7') === 0
                }
            });

            this.listenTo(tooltip, 'skip', this.onSkip);
            this.listenTo(tooltip, 'next', this.onNext);

            return tooltip;
        },

        openFirst: function openFirst() {
            if (this.steps.length > 0) {
                this.steps[0].open();
            }
        },

        onSkip: function onSkip() {
            this.featureDiscovery.markDiscovered('tips');
            _underscore.invoke(this.steps, 'destroy');
            this.destroy();
        },

        onNext: function onNext(target) {
            var index = this.steps.indexOf(target);
            this.steps.splice(index, 1);
            this.openFirst();
        }
    });
});
define('confluence-dashboard/modules/onboarding/onboarding-saved-for-later-view', ['exports', 'module', './onboarding-tooltip-view'], function (exports, module, _onboardingTooltipView) {
    'use strict';

    function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

    var _TooltipView = _interopRequireDefault(_onboardingTooltipView);

    module.exports = _TooltipView['default'].extend({
        showNext: function showNext() {},

        skipTooltips: function skipTooltips() {
            this.featureDiscovery.markDiscovered(this.tipId);
            this.close();
            this.destroy();
        }
    });
});
define('confluence-dashboard/modules/onboarding/onboarding-controller', ['exports', '../../utils/event-manager', './onboarding-view', './onboarding-tooltips-manager', '../../utils/module-starter', 'confluence/meta', '../../utils/conditions', 'ajs', 'confluence-dashboard/soy-templates', './onboarding-saved-for-later-view', 'configuration', '../../utils/feature-discovery'], function (exports, _utilsEventManager, _onboardingView, _onboardingTooltipsManager, _utilsModuleStarter, _confluenceMeta, _utilsConditions, _ajs, _confluenceDashboardSoyTemplates, _onboardingSavedForLaterView, _configuration, _utilsFeatureDiscovery) {
    'use strict';

    function showTips(data) {
        var tooltipManager = new _onboardingTooltipsManager();
        tooltipManager.showTips(data);
    }

    var initOnboarding = function initOnboarding() {
        var isNewUser = _confluenceMeta.getBoolean('is-new-user');
        var shouldShowDialog = _confluenceMeta.getBoolean('show-dashboard-onboarding-dialog');
        var shouldShowTips = _confluenceMeta.getBoolean('show-dashboard-onboarding-tips');

        var SAVED_FOR_LATER_TIP_ID = 'transition-saved-for-later';

        var user = {
            isNew: isNewUser
        };

        if (shouldShowDialog) {
            var dialog = new _onboardingView({
                isNewUser: isNewUser,

                onConfirm: function onConfirm() {
                    showTips(user);
                }
            });

            _utilsEventManager.Commands.execute('main-app:showDialog', dialog);
        } else if (shouldShowTips) {
            showTips(user);
        } else if (!isNewUser) {
            // CONFDEV-38752
            // show the "saved for later instead of favourites" tooltip
            // this won't show at all for NEW users due to the feature discovery code below
            // this won't show for existing users as part of the tour. It will appear for them after a refresh though.
            // this should only show for existing users who have already done the tour.
            var tooltip = new _onboardingSavedForLaterView({
                tipId: SAVED_FOR_LATER_TIP_ID,
                placedNextTo: '.nav-item-container-starred',
                template: _confluenceDashboardSoyTemplates.Onboarding['transitionSavedForLater'],
                templateHelpers: {
                    id: SAVED_FOR_LATER_TIP_ID,
                    isAuiFiveSeven: _ajs.version.indexOf('5.7') === 0
                }
            });
        }

        // new users should never see the saved for later tooltip
        if (isNewUser) {
            var featureDiscovery = _utilsFeatureDiscovery.forPlugin(_configuration.pluginKey);
            featureDiscovery.markDiscovered(SAVED_FOR_LATER_TIP_ID);
        }
    };

    _ajs.toInit(function () {
        if (_utilsConditions.canShowDashboard()) {
            _utilsModuleStarter.register(initOnboarding);
        }
    });
});

require(["confluence-dashboard/modules/onboarding/onboarding-controller"]);
