define('confluence-dashboard/modules/all-updates/all-updates-collection', ['exports', 'module', 'backbone', '../../core/shared/base-collection', 'configuration'], function (exports, module, _backbone, _coreSharedBaseCollection, _configuration) {
    'use strict';

    module.exports = _coreSharedBaseCollection.extend({
        url: _configuration.endpoints.ALL_UPDATES,

        // override the fetch method as this old api isn't REST
        sync: function sync(method, model, options) {
            if (method !== 'read') {
                console.log('Method not implemented for all updates', method);
                return;
            }

            options.data = {
                maxResults: 40,
                tab: 'all',
                showProfilePic: true,
                labels: '',
                spaces: '',
                users: '',
                types: '',
                category: '',
                spaceKey: ''
            };

            return _backbone.sync.call(this, method, model, options);
        },

        parse: function parse(data) {
            return data.changeSets;
        }
    });
});
define('confluence-dashboard/modules/all-updates/all-updates-controller', ['exports', 'module', './all-updates-collection', 'confluence-dashboard/core/content/content-controller', 'confluence-dashboard/core/content/content-as-stream-view', 'confluence-dashboard/soy-templates', 'configuration', 'ajs'], function (exports, module, _allUpdatesCollection, _confluenceDashboardCoreContentContentController, _confluenceDashboardCoreContentContentAsStreamView, _confluenceDashboardSoyTemplates, _configuration, _ajs) {
    'use strict';

    module.exports = _confluenceDashboardCoreContentContentController.extend({
        actionsToFilter: ['allUpdates'],

        allUpdates: function allUpdates() {

            this.view = new _confluenceDashboardCoreContentContentAsStreamView({
                collection: new _allUpdatesCollection(),
                templateHelpers: {
                    title: _ajs.I18n.getText('all.updates.title'),
                    contentType: this.options.name
                },
                emptyViewOptions: {
                    template: _confluenceDashboardSoyTemplates.AllUpdates.blank
                }
            });

            this.view.collection.fetch();
        }
    });
});
