/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dashboard.macros.dao;

import com.atlassian.confluence.api.model.content.Content;
import com.atlassian.confluence.plugins.dashboard.macros.dao.ContentMacroNames;
import com.atlassian.confluence.plugins.dashboard.macros.dao.ContentMacroNamesDao;
import com.atlassian.core.exception.InfrastructureException;
import com.atlassian.hibernate.PluginHibernateSessionFactory;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.hibernate.HibernateException;

public class ContentMacroNamesDatabaseDao
implements ContentMacroNamesDao {
    private static final String SQL_WITH_COMMENTS = String.join((CharSequence)"\n", "select", "  contentOrComment.contentid as contentId,", "  (case when contentOrComment.contenttype = 'COMMENT'", "        then contentOrComment.pageid", "        else null", "        end) as commentParentContentId,", "  stringval as macroNames", "from content as contentOrComment", "left outer join contentproperties property", "                on contentOrComment.contentid = property.contentid", "               and property.propertyname = 'macroNames'", "               and property.stringval != ','", "where contentOrComment.contentid in (:contentIds)", "   or (contentOrComment.contenttype = 'COMMENT' and contentOrComment.pageid in (:contentIds))");
    private static final String SQL_NO_COMMENTS = String.join((CharSequence)"\n", "select", "  content.contentid as contentId,", "  stringval as macroNames", "from content as content", "left outer join contentproperties property", "                on content.contentid = property.contentid", "               and property.propertyname = 'macroNames'", "               and property.stringval != ','", "where content.contentid in (:contentIds)");
    private PluginHibernateSessionFactory pluginSessionFactory;

    public ContentMacroNamesDatabaseDao(PluginHibernateSessionFactory pluginSessionFactory) {
        this.pluginSessionFactory = pluginSessionFactory;
    }

    @Override
    public List<ContentMacroNames> getContentMacroNames(Iterable<Content> contents, List<ContentMacroNames> knownMacroNamesAndComments, boolean includeComments) {
        Iterable contentIds = Iterables.transform(contents, x -> x.getId().asLong());
        String sql = includeComments ? SQL_WITH_COMMENTS : SQL_NO_COMMENTS;
        sql = sql.replace(":contentIds", String.join((CharSequence)",", Iterables.transform(contentIds, id -> Long.toString(id))));
        try {
            Statement statement = this.pluginSessionFactory.getSession().connection().createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            return this.readMacroNames(resultSet, knownMacroNamesAndComments, includeComments);
        }
        catch (SQLException | HibernateException ex) {
            throw new InfrastructureException(ex.getMessage(), ex);
        }
    }

    private List<ContentMacroNames> readMacroNames(ResultSet resultSet, List<ContentMacroNames> knownMacroNamesAndComments, boolean includeComments) throws SQLException {
        List<ContentMacroNames> flattenedContentAndComments = this.readMacroNamesFlattened(resultSet, includeComments);
        List<ContentMacroNames> list = includeComments ? ContentMacroNames.makeCommentHierarchy(flattenedContentAndComments) : flattenedContentAndComments;
        return ContentMacroNames.merge(list, knownMacroNamesAndComments);
    }

    private List<ContentMacroNames> readMacroNamesFlattened(ResultSet resultSet, boolean includeComments) throws SQLException {
        ArrayList<ContentMacroNames> list = new ArrayList<ContentMacroNames>();
        while (resultSet.next()) {
            long contentId = resultSet.getLong("contentId");
            Long commentParentContentId = includeComments ? ContentMacroNamesDatabaseDao.getLongOrNull(resultSet, "commentParentContentId") : null;
            String macroNamesStr = resultSet.getString("macroNames");
            List<String> macroNames = this.readMacroNames(macroNamesStr);
            list.add(new ContentMacroNames(contentId, commentParentContentId, macroNames, null));
        }
        return list;
    }

    private List<String> readMacroNames(String macroNamesStr) {
        if (macroNamesStr == null) {
            return null;
        }
        if (macroNamesStr.endsWith(",")) {
            return null;
        }
        if (macroNamesStr.length() == 0) {
            return Collections.emptyList();
        }
        return Lists.newArrayList(macroNamesStr.split(","));
    }

    private static Long getLongOrNull(ResultSet resultSet, String columnLabel) throws SQLException {
        long value = resultSet.getLong(columnLabel);
        return value != 0L ? Long.valueOf(value) : null;
    }
}

