/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dailysummary.components.impl;

import com.atlassian.confluence.plugins.dailysummary.components.SummaryEmailNotificationManager;
import com.atlassian.confluence.plugins.dailysummary.components.SummaryEmailService;
import com.atlassian.confluence.plugins.dailysummary.components.SummaryEmailTaskFactory;
import com.atlassian.core.task.MultiQueueTaskManager;
import com.atlassian.core.task.Task;
import com.atlassian.fugue.Maybe;
import com.atlassian.mail.queue.MailQueueItem;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.user.User;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSummaryEmailService
implements SummaryEmailService {
    private MultiQueueTaskManager taskManager;
    private SummaryEmailNotificationManager notificationManager;
    private SummaryEmailTaskFactory taskFactory;
    private TransactionTemplate transactionTemplate;
    private static final Logger log = LoggerFactory.getLogger(DefaultSummaryEmailService.class);
    protected static final String MAIL_QUEUE_NAME = "mail";

    public DefaultSummaryEmailService(SummaryEmailTaskFactory taskFactory, MultiQueueTaskManager taskManager, SummaryEmailNotificationManager notificationManager, TransactionTemplate transactionTemplate) {
        this.taskManager = taskManager;
        this.taskFactory = taskFactory;
        this.notificationManager = notificationManager;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public int sendEmailForDate(Date date) {
        int batchSize = Integer.getInteger("daily-summary-email.batchsize", 20);
        if (batchSize < 1) {
            throw new IllegalStateException("daily-summary-email.batchsize should be larger than 0 :" + batchSize);
        }
        Iterator<User> users = this.notificationManager.getUsersToReceiveNotificationAt(date).iterator();
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        log.info("Summary email job firing @ {}, scheduled fire time was : {}.  {} users to receive notifications.", new Object[]{new Date(), date, users != null ? users.hasNext() : false});
        AtomicInteger totalSent = new AtomicInteger(0);
        while (users != null && users.hasNext()) {
            try {
                this.transactionTemplate.execute(() -> {
                    int counter = 0;
                    for (int i = 0; i < batchSize && users.hasNext(); ++i) {
                        User user = (User)users.next();
                        try {
                            counter += this.doSend(user, date);
                            continue;
                        }
                        catch (Exception ex) {
                            exceptions.add(ex);
                        }
                    }
                    totalSent.getAndAdd(counter);
                    return Boolean.TRUE;
                });
            }
            catch (Exception ex) {
                exceptions.add(ex);
            }
        }
        if (exceptions.size() > 0) {
            log.error("{} exceptions thrown sending the daily summary email, turn on WARN level logging for com.atlassian.confluence.plugins.dailysummary.components.impl for more details", (Object)exceptions.size());
            for (Exception ex : exceptions) {
                log.warn("Exception thrown sending the daily summary email", (Throwable)ex);
            }
        }
        return totalSent.get();
    }

    private int doSend(User user, Date date) {
        int taskCount = 0;
        Maybe<MailQueueItem> email = this.taskFactory.createEmailTask(user, date);
        if (email.isDefined()) {
            ++taskCount;
            this.taskManager.addTask(MAIL_QUEUE_NAME, (Task)email.get());
        } else {
            log.debug("Summary email does not have content for user {}", (Object)user);
        }
        return taskCount;
    }

    @Override
    public boolean sendEmail(User user, Date date) {
        return (Integer)this.transactionTemplate.execute(() -> this.doSend(user, date)) > 0;
    }
}

