/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.dailysummary.components.impl;

import com.atlassian.confluence.plugins.dailysummary.components.SummaryEmailNotificationManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.settings.CoreFeaturesManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.ConfluenceUserPreferences;
import com.atlassian.confluence.user.PersonalInformationManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.core.user.preferences.UserPreferences;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.search.page.Pager;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSummaryEmailNotificationManager
implements SummaryEmailNotificationManager {
    private final UserManager userManager;
    private final UserAccessor userAccessor;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final SettingsManager settingsManager;
    private final PersonalInformationManager personalInformationManager;
    private final PermissionManager permissionManager;
    private final LoginManager loginManager;
    private final CoreFeaturesManager coreFeaturesManager;
    private static final int DEFAULT_HOUR = Integer.getInteger("daily.summary.send.hour", 13);
    private static final int DEFAULT_DAY_OF_WEEK = Integer.getInteger("daily.summary.send.dayofweek", 5);
    private static final Logger log = LoggerFactory.getLogger(DefaultSummaryEmailNotificationManager.class);
    private static final int FIRST_DAY_OF_WEEKEND = Integer.getInteger("daily.summary.weekend.one", 7);
    private static final int SECOND_DAY_OF_WEEKEND = Integer.getInteger("daily.summary.weekend.two", 1);

    public DefaultSummaryEmailNotificationManager(UserManager userManager, UserAccessor userAccessor, PluginSettingsFactory pluginSettingsFactory, SettingsManager settingsManager, PersonalInformationManager personalInformationManager, PermissionManager permissionManager, LoginManager loginManager, CoreFeaturesManager coreFeaturesManager) {
        this.userManager = userManager;
        this.userAccessor = userAccessor;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.settingsManager = settingsManager;
        this.personalInformationManager = personalInformationManager;
        this.permissionManager = permissionManager;
        this.loginManager = loginManager;
        this.coreFeaturesManager = coreFeaturesManager;
    }

    @Override
    public Iterable<User> getUsersToReceiveNotificationAt(Date date) {
        if (date == null) {
            throw new IllegalArgumentException("Notification date is null");
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        try {
            Pager userPager = this.userManager.getUserNames();
            Function<String, User> usernameToUser = new Function<String, User>(){

                public User apply(String username) {
                    return DefaultSummaryEmailNotificationManager.this.userAccessor.getUserByName(username);
                }
            };
            return Iterables.filter((Iterable)Iterables.transform((Iterable)userPager, (Function)usernameToUser), this.getUserFilter(cal));
        }
        catch (EntityException ex) {
            throw new RuntimeException("Could not determine set of users to send daily email to", ex);
        }
    }

    private String getDefaultSchedule(PluginSettings settings) {
        String defaultVal = (String)settings.get("atl.confluence.plugins.confluence-daily-summary-email:admin.defaultSchedule");
        if (defaultVal == null) {
            defaultVal = "weekly";
            settings.put("atl.confluence.plugins.confluence-daily-summary-email:admin.defaultSchedule", (Object)defaultVal);
        }
        return defaultVal;
    }

    private boolean getDefaultEnabled(PluginSettings pluginSettings, Settings globalSettings) {
        String defaultStr = (String)pluginSettings.get("atl.confluence.plugins.confluence-daily-summary-email:admin.defaultEnabled");
        if (defaultStr == null) {
            boolean enabled = this.settingsManager.getGlobalSettings().isDenyPublicSignup();
            pluginSettings.put("atl.confluence.plugins.confluence-daily-summary-email:admin.defaultEnabled", (Object)Boolean.toString(enabled));
            return enabled;
        }
        return Boolean.parseBoolean(defaultStr);
    }

    protected Predicate<User> getUserFilter(final Calendar cal) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        final Settings globalSettings = this.settingsManager.getGlobalSettings();
        final String defaultSchedule = this.getDefaultSchedule(pluginSettings);
        final boolean defaultEnabled = this.getDefaultEnabled(pluginSettings, globalSettings);
        return new Predicate<User>(){

            public boolean apply(User user) {
                boolean sendMail;
                String schedule;
                if (user == null || StringUtils.isBlank((String)user.getEmail())) {
                    return false;
                }
                ConfluenceUserPreferences confluenceUserPreferences = DefaultSummaryEmailNotificationManager.this.userAccessor.getConfluenceUserPreferences(user);
                UserPreferences userPreferences = confluenceUserPreferences.getWrappedPreferences();
                TimeZone tz = confluenceUserPreferences.getTimeZone().getWrappedTimeZone();
                if (tz != null) {
                    cal.setTimeZone(tz);
                }
                if ((schedule = userPreferences.getString("confluence.prefs.daily.summary.schedule")) == null) {
                    schedule = defaultSchedule;
                }
                if (cal.get(11) != DEFAULT_HOUR && !schedule.equals("hourly")) {
                    log.debug("Not sending email to {}, hour of day is {} and needs to be {} in timezone : {}", new Object[]{user.getName(), cal.get(11), DEFAULT_HOUR, cal.getTimeZone()});
                    return false;
                }
                if (userPreferences.getBoolean("confluence.prefs.daily.summary.receive.updates.set")) {
                    if (!userPreferences.getBoolean("confluence.prefs.daily.summary.receive.updates")) {
                        log.debug("User {} is not subscribed to updates {} or not set and default is not enabled {}", new Object[]{user, userPreferences.getBoolean("confluence.prefs.daily.summary.receive.updates"), defaultEnabled});
                        return false;
                    }
                } else {
                    if (!defaultEnabled) {
                        return false;
                    }
                    if (!DefaultSummaryEmailNotificationManager.this.shouldSendToUserByDefault(user, globalSettings)) {
                        return false;
                    }
                }
                boolean bl = sendMail = schedule.equals("daily") && cal.get(7) != FIRST_DAY_OF_WEEKEND && cal.get(7) != SECOND_DAY_OF_WEEKEND || schedule.equals("weekly") && cal.get(7) == DEFAULT_DAY_OF_WEEK || schedule.equals("hourly");
                if (log.isDebugEnabled()) {
                    log.debug("Evaluating summary email condition for {} sending is: {}, hour : {}, enabled {}, schedule {}, dayofweek {}", new Object[]{user, sendMail, cal.get(11), userPreferences.getBoolean("confluence.prefs.daily.summary.receive.updates"), schedule, cal.get(7)});
                }
                return sendMail && DefaultSummaryEmailNotificationManager.this.permissionManager.hasPermission(user, Permission.VIEW, PermissionManager.TARGET_APPLICATION);
            }
        };
    }

    private boolean shouldSendToUserByDefault(User user, Settings globalSettings) {
        LoginInfo loginInfo = this.loginManager.getLoginInfo(user);
        if (loginInfo == null || loginInfo.getLastSuccessfulLoginDate() == null) {
            log.debug("User {} from external management has no successful previous login, not sending daily summary", (Object)user.getName());
            return false;
        }
        return true;
    }
}

