/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.listeners;

import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.TemplatePageCreateEvent;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.plugins.createcontent.api.contextproviders.BlueprintContextKeys;
import com.atlassian.confluence.plugins.createcontent.impl.ContentTemplateRef;
import com.atlassian.event.api.EventListener;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TemplateChildCreatorListener {
    private final BlueprintManager blueprintManager;

    public TemplateChildCreatorListener(BlueprintManager blueprintManager) {
        this.blueprintManager = blueprintManager;
    }

    @EventListener
    public void onCreateEvent(TemplatePageCreateEvent event) {
        ContentTemplateRef templateRef = event.getTemplateRef();
        List<ContentTemplateRef> children = templateRef.getChildren();
        if (children.isEmpty()) {
            return;
        }
        Page parentPage = event.getPage();
        String parentTitle = parentPage.getTitle();
        Map<String, Object> originalContext = event.getContext();
        boolean addPageTitlePrefix = !"true".equals(originalContext.get(BlueprintContextKeys.NO_PAGE_TITLE_PREFIX.key()));
        for (ContentTemplateRef child : children) {
            HashMap childContext = Maps.newHashMap(originalContext);
            childContext.remove("ContentPageTitle");
            childContext.put("UsePageTemplateNameForTitle", true);
            if (addPageTitlePrefix) {
                childContext.put("ParentPageTitle", parentTitle);
            }
            this.blueprintManager.createPageFromTemplate(child, event.getUser(), parentPage.getSpace(), parentPage, childContext, event.getSaveContext());
        }
    }
}

