/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateBlueprintPageRestEntity;
import com.atlassian.confluence.plugins.createcontent.services.RequestStorage;
import com.atlassian.confluence.plugins.createcontent.services.model.CreateBlueprintPageEntity;
import com.atlassian.sal.api.web.context.HttpContext;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.jackson.map.ObjectMapper;

public class DefaultRequestStorage
implements RequestStorage {
    private static final String DRAFT_CREATE_REQUEST = "create.blueprint.page.draft.request";
    private final HttpContext httpContext;
    private final ContentPropertyManager contentPropertyManager;
    private final ObjectMapper objectMapper;

    public DefaultRequestStorage(HttpContext httpContext, ContentPropertyManager contentPropertyManager) {
        this.httpContext = httpContext;
        this.contentPropertyManager = contentPropertyManager;
        this.objectMapper = new ObjectMapper();
    }

    @Override
    public void storeCreateRequest(CreateBlueprintPageEntity createRequest, ContentEntityObject ceo) {
        if (ceo.isPersistent()) {
            try {
                String jsonRequest = this.objectMapper.writeValueAsString((Object)createRequest);
                this.contentPropertyManager.setTextProperty(ceo, DRAFT_CREATE_REQUEST, jsonRequest);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.getSession().setAttribute(this.getAttributeKey(ceo), (Object)createRequest);
        }
    }

    @Override
    public CreateBlueprintPageEntity retrieveRequest(ContentEntityObject ceo) {
        CreateBlueprintPageEntity request;
        if (ceo.isPersistent()) {
            String jsonRequest = this.contentPropertyManager.getTextProperty(ceo, DRAFT_CREATE_REQUEST);
            if (StringUtils.isBlank((CharSequence)jsonRequest)) {
                throw new IllegalStateException("No persisted CreateBlueprint request found for draft with id: " + ceo.getId());
            }
            try {
                request = (CreateBlueprintPageEntity)this.objectMapper.readValue(jsonRequest, CreateBlueprintPageRestEntity.class);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            request = (CreateBlueprintPageEntity)this.getSession().getAttribute(this.getAttributeKey(ceo));
        }
        return request;
    }

    @Override
    public void clear(ContentEntityObject ceo) {
        if (ceo.isPersistent()) {
            this.contentPropertyManager.removeProperty(ceo, DRAFT_CREATE_REQUEST);
        } else {
            this.getSession().removeAttribute(this.getAttributeKey(ceo));
        }
    }

    private String getAttributeKey(ContentEntityObject ceo) {
        return DRAFT_CREATE_REQUEST + ceo.getIdAsString();
    }

    private HttpSession getSession() {
        return this.httpContext.getSession(true);
    }
}

