/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.plugins.createcontent.impl;

import com.atlassian.confluence.plugins.createcontent.rest.entities.CreateDialogWebItemEntity;
import com.atlassian.confluence.plugins.createcontent.services.BlueprintDiscoveryService;
import com.atlassian.confluence.plugins.featurediscovery.service.FeatureDiscoveryService;
import com.atlassian.plugin.ModuleCompleteKey;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DefaultBlueprintDiscoveryService
implements BlueprintDiscoveryService {
    private final FeatureDiscoveryService featureDiscoveryService;

    public DefaultBlueprintDiscoveryService(FeatureDiscoveryService featureDiscoveryService) {
        this.featureDiscoveryService = featureDiscoveryService;
    }

    @Override
    public List<CreateDialogWebItemEntity> discoverRecentlyInstalled(List<CreateDialogWebItemEntity> pluginItems) {
        List<ModuleCompleteKey> blueprintsModuleCompleteKeys = this.getBlueprintModuleCompleteKeys(pluginItems);
        List recentBlueprintsModuleCompleteKeys = this.featureDiscoveryService.getNew(blueprintsModuleCompleteKeys);
        this.updateRecentBlueprintItems(pluginItems, recentBlueprintsModuleCompleteKeys);
        return pluginItems;
    }

    private List<ModuleCompleteKey> getBlueprintModuleCompleteKeys(List<CreateDialogWebItemEntity> pluginItems) {
        ArrayList blueprintKeys = Lists.newArrayList();
        for (CreateDialogWebItemEntity createDialogWebItemEntity : pluginItems) {
            String blueprintModuleCompleteKey = createDialogWebItemEntity.getItemModuleCompleteKey();
            if (!StringUtils.isNotBlank((CharSequence)blueprintModuleCompleteKey)) continue;
            blueprintKeys.add(new ModuleCompleteKey(blueprintModuleCompleteKey));
        }
        return blueprintKeys;
    }

    private void updateRecentBlueprintItems(List<CreateDialogWebItemEntity> pluginItems, List<ModuleCompleteKey> newBlueprintModuleKeys) {
        HashSet newBlueprintModuleKeySet = Sets.newHashSet(newBlueprintModuleKeys);
        for (CreateDialogWebItemEntity createDialogWebItemEntity : pluginItems) {
            String blueprintModuleCompleteKey = createDialogWebItemEntity.getItemModuleCompleteKey();
            if (StringUtils.isBlank((CharSequence)blueprintModuleCompleteKey) || !newBlueprintModuleKeySet.contains(new ModuleCompleteKey(blueprintModuleCompleteKey))) continue;
            createDialogWebItemEntity.setNew(true);
        }
    }
}

